% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_rename}
\alias{step_rename}
\title{Rename variables in survey data (step)}
\usage{
step_rename(
  svy,
  ...,
  mapping = NULL,
  .copy = use_copy_default(),
  comment = "Rename variables",
  use_copy = deprecated(),
  lazy = lazy_default(),
  record = TRUE
)
}
\arguments{
\item{svy}{A Survey or RotativePanelSurvey object}

\item{...}{Pairs in the form \code{new_name = old_name} (unquoted).}

\item{mapping}{A named character vector of the form
\code{c(new_name = "old_name")}. Alternative to \code{...} for
programmatic use.}

\item{.copy}{Whether to operate on a copy (default: \code{use_copy_default()})}

\item{comment}{Descriptive text for the step for
documentation and traceability (default \code{"Rename variables"}).}

\item{use_copy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{.copy} instead.}

\item{lazy}{Internal. Whether to delay execution (default \code{lazy_default()}).}

\item{record}{Internal. Whether to record the step (default \code{TRUE}).}
}
\value{
Survey object with the specified variables
renamed (or queued for renaming).
}
\description{
Creates a step that renames variables in the survey data when baked.
}
\details{
\strong{Lazy evaluation (default):} By default, steps are recorded but
\strong{not executed} until \code{\link[=bake_steps]{bake_steps()}} is called.

Variables can be renamed in two ways:
\itemize{
\item \strong{Unquoted pairs:} \code{step_rename(svy, new_name = old_name)}
\item \strong{Named character vector:} \code{step_rename(svy, mapping = c(new_name = "old_name"))}
}

Variables that don't exist in the data cause an error, unlike
\code{\link[=step_remove]{step_remove()}} which issues a warning.
}
\examples{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
svy2 <- step_rename(svy, edad = age)
svy2 <- bake_steps(svy2)
"edad" \%in\% names(get_data(svy2)) # TRUE
}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
