% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mids.R
\name{mids}
\alias{mids}
\alias{mids-class}
\alias{plot.mids}
\alias{print.mids}
\alias{summary.mids}
\title{Multiply imputed data set (\code{mids})}
\usage{
mids(
  data = data.frame(),
  imp = list(),
  m = integer(),
  where = matrix,
  blocks = list(),
  call = match.call(),
  nmis = integer(),
  method = character(),
  predictorMatrix = matrix(),
  visitSequence = character(),
  formulas = list(),
  calltype = character(),
  post = character(),
  blots = list(),
  ignore = logical(),
  seed = integer(),
  iteration = integer(),
  lastSeedValue = tryCatch(get(".Random.seed", envir = globalenv(), mode = "integer",
    inherits = FALSE), error = function(e) NULL),
  chainMean = list(),
  chainVar = list(),
  loggedEvents = data.frame(),
  version = packageVersion("mice"),
  date = Sys.Date()
)

\method{plot}{mids}(
  x,
  y = NULL,
  theme = mice.theme(),
  layout = c(2, 3),
  type = "l",
  col = 1:10,
  lty = 1,
  ...
)

\method{print}{mids}(x, ...)

\method{summary}{mids}(object, ...)
}
\arguments{
\item{data}{A data frame or a matrix containing the incomplete data.  Missing
values are coded as \code{NA}.}

\item{imp}{Calculated field}

\item{m}{Number of multiple imputations. The default is \code{m=5}.}

\item{where}{A data frame or matrix with logicals of the same dimensions
as \code{data} indicating where in the data the imputations should be
created. The default, \code{where = is.na(data)}, specifies that the
missing data should be imputed. The \code{where} argument may be used to
overimpute observed data, or to skip imputations for selected missing values.
Note: Imputation methods that generate imptutations outside of
\code{mice}, like \code{mice.impute.panImpute()} may depend on a complete
predictor space. In that case, a custom \code{where} matrix can not be
specified.}

\item{blocks}{List of vectors with variable names per block. List elements
may be named to identify blocks. Variables within a block are
imputed by a multivariate imputation method
(see \code{method} argument). By default each variable is placed
into its own block, which is effectively
fully conditional specification (FCS) by univariate models
(variable-by-variable imputation). Only variables whose names appear in
\code{blocks} are imputed. The relevant columns in the \code{where}
matrix are set to \code{FALSE} of variables that are not block members.
A variable may appear in multiple blocks. In that case, it is
effectively re-imputed each time that it is visited.}

\item{call}{Calculated field}

\item{nmis}{Calculated field}

\item{method}{Can be either a single string, or a vector of strings with
length \code{length(blocks)}, specifying the imputation method to be
used for each column in data. If specified as a single string, the same
method will be used for all blocks. The default imputation method (when no
argument is specified) depends on the measurement level of the target column,
as regulated by the \code{defaultMethod} argument. Columns that need
not be imputed have the empty method \code{""}. See details.}

\item{predictorMatrix}{A numeric matrix of \code{length(blocks)} rows
and \code{ncol(data)} columns, containing 0/1 data specifying
the set of predictors to be used for each target column.
Each row corresponds to a variable block, i.e., a set of variables
to be imputed. A value of \code{1} means that the column
variable is used as a predictor for the target block (in the rows).
By default, the \code{predictorMatrix} is a square matrix of \code{ncol(data)}
rows and columns with all 1's, except for the diagonal.
Note: For two-level imputation models (which have \code{"2l"} in their names)
other codes (e.g, \code{2} or \code{-2}) are also allowed.}

\item{visitSequence}{A vector of block names of arbitrary length, specifying the
sequence of blocks that are imputed during one iteration of the Gibbs
sampler. A block is a collection of variables. All variables that are
members of the same block are imputed
when the block is visited. A variable that is a member of multiple blocks
is re-imputed within the same iteration.
The default \code{visitSequence = "roman"} visits the blocks (left to right)
in the order in which they appear in \code{blocks}.
One may also use one of the following keywords: \code{"arabic"}
(right to left), \code{"monotone"} (ordered low to high proportion
of missing data) and \code{"revmonotone"} (reverse of monotone).
\emph{Special case}: If you specify both \code{visitSequence = "monotone"} and
\code{maxit = 1}, then the procedure will edit the \code{predictorMatrix}
to conform to the monotone pattern. Realize that convergence in one
iteration is only guaranteed if the missing data pattern is actually
monotone. The procedure does not check this.}

\item{formulas}{A named list of formula's, or expressions that
can be converted into formula's by \code{as.formula}. List elements
correspond to blocks. The block to which the list element applies is
identified by its name, so list names must correspond to block names.
The \code{formulas} argument is an alternative to the
\code{predictorMatrix} argument that allows for more flexibility in
specifying imputation models, e.g., for specifying interaction terms.}

\item{calltype}{A character vector of \code{length(block)} elements
that indicates how the imputation model is specified. Entries can
one of two values: \code{"pred"} or \code{"formula"}. If
\code{calltype = "pred"}, the predictors of the imputation
model for the block are specified by the corresponding row of the
\code{predictorMatrix}. If  \code{calltype = "formula"} the
imputation model is specified by relevant entry in
\code{formulas}. The default depends on the presence of the
\code{formulas} argument. If \code{formulas} is present, then
\code{mice()} sets
\code{calltype = "formula"} for any block
for which a formula is specified. Otherwise, \code{calltype = "pred"}.}

\item{post}{A vector of strings with length \code{ncol(data)} specifying
expressions as strings. Each string is parsed and
executed within the \code{sampler()} function to post-process
imputed values during the iterations.
The default is a vector of empty strings, indicating no post-processing.
Multivariate (block) imputation methods ignore the \code{post} parameter.}

\item{blots}{A named \code{list} of \code{alist}'s that can be used
to pass down arguments to lower level imputation function. The entries
of element \code{blots[[blockname]]} are passed down to the function
called for block \code{blockname}.}

\item{ignore}{A logical vector of \code{nrow(data)} elements indicating
which rows are ignored when creating the imputation model. The default
\code{NULL} includes all rows that have an observed value of the variable
to imputed. Rows with \code{ignore} set to \code{TRUE} do not influence the
parameters of the imputation model, but are still imputed. We may use the
\code{ignore} argument to split \code{data} into a training set (on which the
imputation model is built) and a test set (that does not influence the
imputation model estimates).
Note: Multivariate imputation methods, like \code{mice.impute.jomoImpute()}
or \code{mice.impute.panImpute()}, do not honour the \code{ignore} argument.}

\item{seed}{An integer that is used as argument by the \code{set.seed()} for
offsetting the random number generator. Default is to leave the random number
generator alone.}

\item{iteration}{Calculated field}

\item{lastSeedValue}{Calculated field}

\item{chainMean}{Calculated field}

\item{chainVar}{Calculated field}

\item{loggedEvents}{Calculated field}

\item{version}{Calculated field}

\item{date}{Calculated field}

\item{x}{An object of class \code{mids}}

\item{y}{A formula that specifies which variables, stream and iterations are plotted.
If omitted, all streams, variables and iterations are plotted.}

\item{theme}{The trellis theme to applied to the graphs. The default is \code{mice.theme()}.}

\item{layout}{A vector of length 2 given the number of columns and rows in the plot.
The default is \code{c(2, 3)}.}

\item{type}{Parameter \code{type} of \code{\link[lattice]{panel.xyplot}}.}

\item{col}{Parameter \code{col} of \code{\link[lattice]{panel.xyplot}}.}

\item{lty}{Parameter \code{lty} of \code{\link[lattice]{panel.xyplot}}.}

\item{\dots}{Others arguments}

\item{object}{Object of class \code{mids}}
}
\value{
\code{mids()} returns a \code{mids} object.

\code{plot()} returns a \code{\link[lattice]{xyplot}} object.

\code{print()} returns the input object invisibly.

\code{summary()} returns the input object invisibly.
}
\description{
The \code{mids} object is an S3 class that represents a multiply imputed
data set. The \code{mids()} function is the S3 constructor.
The following functions produce a \code{mids} object:
\code{mids()}, \code{\link{mice}()}, \code{\link{mice.mids}()},
\code{\link{cbind}()}, \code{\link{rbind}()}, \code{\link{ibind}()},
\code{\link{as.mids}()} and \code{\link{filter}()}.
}
\details{
The S3 class \code{mids} has the following methods:
\code{\link{bwplot}()}, \code{\link{complete}()},
\code{\link{densityplot}()}, \code{plot()},
\code{print()}, \code{\link{stripplot}()}, \code{summary()},
\code{\link{with}()} and \code{\link{xyplot}()}.
}
\section{Structure}{

Objects of class \code{"mids"} are lists with the following elements:
\describe{
\item{\code{data}:}{Original (incomplete) data set.}
\item{\code{imp}:}{A list of \code{ncol(data)} components with
the generated multiple imputations. Each list component is a
\code{data.frame} (\code{nmis[j]} by \code{m}) of imputed values
for variable \code{j}. A \code{NULL} component is used for
variables for which not imputations are generated.}
\item{\code{m}:}{Number of imputations.}
\item{\code{where}:}{The \code{where} argument of the
\code{mice()} function.}
\item{\code{blocks}:}{The \code{blocks} argument of the
\code{mice()} function.}
\item{\code{call}:}{Call that created the object.}
\item{\code{nmis}:}{An Named vector with counts of missing values per variable}
\item{\code{method}:}{A vector of strings of \code{length(blocks}
specifying the imputation method per block.}
\item{\code{predictorMatrix}:}{A numerical matrix of containing
integers specifying the predictor set.}
\item{\code{visitSequence}:}{A vector of variable and block names that
specifies how variables and blocks are visited in one iteration throuh
the data.}
\item{\code{formulas}:}{A named list of formula's, or expressions that
can be converted into formula's by \code{as.formula}. List elements
correspond to blocks. The block to which the list element applies is
identified by its name, so list names must correspond to block names.}
\item{\code{post}:}{A vector of strings of length \code{length(blocks)}
with commands for post-processing.}
\item{\code{blots}:}{"Block dots". The \code{blots} argument to the \code{mice()}
function.}
\item{\code{ignore}:}{A logical vector of length \code{nrow(data)} indicating
the rows in \code{data} used to build the imputation model. (new in \code{mice 3.12.0})}
\item{\code{seed}:}{The seed value of the solution.}
\item{\code{iteration}:}{Last Gibbs sampling iteration number.}
\item{\code{lastSeedValue}:}{Random number generator state.}
\item{\code{chainMean}:}{An array of dimensions \code{ncol} by
\code{maxit} by \code{m} elements containing the mean of
the generated multiple imputations.
The array can be used for monitoring convergence.
Note that observed data are not present in this mean.}
\item{\code{chainVar}:}{An array with similar structure as
\code{chainMean}, containing the variance of the imputed values.}
\item{\code{loggedEvents}:}{A \code{data.frame} with five columns
containing warnings, corrective actions, and other inside info.}
\item{\code{version}:}{Version number of \code{mice} package that
created the object.}
\item{\code{date}:}{Date at which the object was created.}
}
}

\section{LoggedEvents}{

The \code{loggedEvents} entry is a matrix with five columns containing a
record of automatic removal actions. It is \code{NULL} is no action was
made.  At initialization the program removes constant variables, and
removes variables to cause collinearity.
During iteration, the program does the following actions:
\itemize{
\item One or more variables that are linearly dependent are removed
(for categorical data, a 'variable' corresponds to a dummy variable)
\item  Proportional odds regression imputation that does not converge
and is replaced by \code{polyreg}.
}

Explanation of elements in \code{loggedEvents}:
\describe{
\item{\code{it}}{iteration number at which the record was added,}
\item{\code{im}}{imputation number,}
\item{\code{dep}}{name of the dependent variable,}
\item{\code{meth}}{imputation method used,}
\item{\code{out}}{a (possibly long) character vector with the
names of the altered or removed predictors.}
}
}

\section{Methods}{

The \code{mids} class of objects has methods for the following
generic functions: \code{print}, \code{summary}, \code{plot}.
}

\section{Plot}{

The \code{plot()} metho plots the trace lines of the MICE algorithm.
The \code{plot} method for a \code{mids} object plots the mean imputed
value per imputation and the mean standard deviation of the imputed
values against the iteration number for each of the $m$ replications.
By default, the function creates a plot for each incomplete
variable. On convergence, the streams should intermingle and be free
of any trend.
}

\examples{
data <- data.frame(a = c(1, NA, 3), b = c(NA, 2, 3))
q <- list(
  a = structure(
    list(`1` = 3, `2` = 3, `3` = 3, `4` = 3, `5` = 3),
         row.names = "2", class = "data.frame"),
  b = structure(
    list(`1` = 3, `2` = 3, `3` = 2, `4` = 2, `5` = 3),
         row.names = "1", class = "data.frame"))

imp <- mids(
  data = data,
  imp = q,
  m = 5,
  where = is.na(data),
  blocks = list(a = "a", b = "b"),
  nmis = colSums(is.na(data)),
  method = c(a = "mean", b = "norm"),
  predictorMatrix = matrix(1, nrow = 2, ncol = 2, dimnames = list(c("a", "b"), c("a", "b"))),
  visitSequence = c("a", "b"),
  formulas = list(a = a ~ b, b = b ~ a),
  post = NULL,
  blots = NULL,
  ignore = logical(nrow(data)),
  seed = 123,
  iteration = 1,
  chainMean = list(a = c(1, 2, 3), b = c(3, 2, 1)),
  chainVar = list(a = c(1.1, 1.2, 1.3), b = c(0.9, 1.0, 1.1)),
  loggedEvents = NULL)

print(imp)
imp <- mice(nhanes, print = FALSE)
plot(imp, bmi + chl ~ .it | .ms, layout = c(2, 1))
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\doi{10.18637/jss.v045.i03}
}
\seealso{
\code{\link{mice}}, \code{\link{mira}},
\code{\link{mipo}}, \code{\link[lattice]{xyplot}}
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn
}
\keyword{classes}
