% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plyPlaneCut.R
\name{plyPlaneCut}
\alias{plyPlaneCut}
\title{Cut a PLY Mesh Along a Specified Plane (HTML widget; no Quartz)}
\usage{
plyPlaneCut(
  plyFile,
  axis = "Z",
  vertIndex = NA,
  cut_value = NA,
  keepBoth = FALSE,
  plane = NA,
  flipAxis = FALSE,
  display = TRUE,
  kept_col = "#3C8DFF",
  other_col = "gray70",
  plane_col = "firebrick",
  plane_alpha = 0.35,
  main = "",
  widget_size_px = 768,
  scene_zoom = 1.5,
  leftOffset = 0,
  fieldofview = 0,
  title_font_size_px = 30,
  title_font_family =
    "system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif"
)
}
\arguments{
\item{plyFile}{An object of class 'mesh3d'.}

\item{axis}{Character, one of "X","Y","Z"; used when deriving the plane from a
vertex index or a numeric cut value (ignored when 'plane' is supplied). Default "Z".}

\item{vertIndex}{Integer index of a mesh vertex used to place an orthogonal plane
through that vertex along 'axis'. Ignored if 'plane' or 'cut_value' is supplied.}

\item{cut_value}{Numeric coordinate along 'axis' at which to place the orthogonal
plane. Ignored if 'plane' is supplied. (HTML-friendly alternative to interactive pick)}

\item{keepBoth}{Logical; if TRUE and the plane intersects the mesh, return both
sides as a list with elements 'meshA' and 'meshB'. Default FALSE.}

\item{plane}{Numeric vector c(a,b,c,d) giving a plane in ax + by + cz + d = 0 form.
If provided, overrides 'axis', 'vertIndex', and 'cut_value'.}

\item{flipAxis}{Logical; reverse the plane normal direction used to decide which
side is kept when keepBoth = FALSE. Default FALSE.}

\item{display}{Logical; if TRUE, render an HTML widget preview. Default TRUE.}

\item{kept_col}{Color for the kept portion in the preview (default "#3C8DFF").}

\item{other_col}{Color for the other portion in the preview (default "gray70").}

\item{plane_col}{Color for the plane polygon in the preview (default "firebrick").}

\item{plane_alpha}{Alpha for the plane polygon (default 0.35).}

\item{main}{Plot title (default "")}

\item{widget_size_px}{Square widget size in pixels (default 768)}

\item{scene_zoom}{Initial zoom for the 3D scene (default 1.5)}

\item{leftOffset}{Horizontal camera nudge (-1..1 recommended) (default 0)}

\item{fieldofview}{Field of view in degrees (0 = isometric) (default 0)}

\item{title_font_size_px}{Title font size in pixels (default 30)}

\item{title_font_family}{CSS font-family list for the title (default system UI stack)}
}
\value{
If keepBoth = FALSE, a 'mesh3d' for the retained side.
If keepBoth = TRUE, a list with elements 'meshA' and 'meshB'.
The returned object also carries an attribute 'widget' with the
\code{htmltools::browsable} preview when \code{display = TRUE}.
}
\description{
Cuts a mesh by a plane and returns either one side or both sides of the cut.
The result is also previewed as an HTML widget (no Quartz/X11) with the kept
side in solid color, the other side semi-transparent, and the cutting plane shown.
}
\details{
This HTML-widget version avoids opening a native rgl window and mirrors the
device-and-layout pattern you used in your updated \code{DNE3d}. Interactive vertex
picking (\code{select3d}) isn’t supported in widget mode; supply the cut as \code{plane},
\code{vertIndex} + \code{axis}, or \code{cut_value} + \code{axis}. The kept side selection is
controlled by the normal direction and \code{flipAxis}.
}
