% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multibias_plot.R
\name{multibias_plot}
\alias{multibias_plot}
\title{Create a Forest Plot comparing observed and adjusted effect estimates}
\usage{
multibias_plot(data_observed, multibias_result_list, log_scale = FALSE)
}
\arguments{
\item{data_observed}{Object of class \code{data_observed} representing the
observed causal data and effect of interest.}

\item{multibias_result_list}{A named list of sensitivity analysis results.
Each element should be a result from \code{\link[=multibias_adjust]{multibias_adjust()}}.}

\item{log_scale}{Boolean indicating whether to display the x-axis on the
log scale. Default is FALSE.}
}
\value{
A ggplot object showing a forest plot with:
\itemize{
\item Point estimates (blue dots)
\item Confidence intervals (gray horizontal lines)
\item A vertical reference line at x=1 (dashed)
\item Appropriate labels and title
}
}
\description{
This function generates a forest plot comparing the observed effect estimate
with adjusted effect estimates from sensitivity analyses. The plot includes
point estimates and confidence intervals for each analysis.
}
\examples{
\dontrun{
df_observed <- data_observed(
  data = df_em,
  bias = "em",
  exposure = "Xstar",
  outcome = "Y",
  confounders = "C1"
)

bp1 <- bias_params(coef_list = list(x = c(-2.10, 1.62, 0.63, 0.35)))
bp2 <- bias_params(coef_list = list(x = c(-2.10 * 2, 1.62 * 2, 0.63 * 2, 0.35 * 2)))

result1 <- multibias_adjust(
  data_observed = df_observed,
  bias_params = bp1
)
result2 <- multibias_adjust(
  data_observed = df_observed,
  bias_params = bp2
)

multibias_plot(
  data_observed = df_observed,
  multibias_result_list = list(
    "Adjusted with bias params" = result1,
    "Adjusted with bias params doubled" = result2
  )
)
}

}
