% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discriminant_projector.R
\name{predict.discriminant_projector}
\alias{predict.discriminant_projector}
\title{Predict method for a discriminant_projector, supporting LDA or Euclid}
\usage{
\method{predict}{discriminant_projector}(
  object,
  new_data,
  method = c("lda", "euclid"),
  type = c("class", "prob"),
  colind = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{discriminant_projector} object.}

\item{new_data}{A numeric matrix (or vector) with the same # of columns as
the original data (unless partial usage). Rows=observations, columns=features.}

\item{method}{Either \code{"lda"} (the default) or \code{"euclid"} (nearest-mean).}

\item{type}{\code{"class"} (default) for predicted class labels, or \code{"prob"}
for posterior-like probabilities.}

\item{colind}{(optional) if partial columns are used, specify which columns
map to the subspace. If \code{NULL}, assume full columns.}

\item{...}{further arguments (not used or for future expansions).}
}
\value{
If \code{type="class"}, a factor vector of length n (predicted classes).
If \code{type="prob"}, an (n x #classes) numeric matrix of posterior-like values, with row names matching \code{new_data} if available.

Predict method for a discriminant_projector

This produces class predictions or posterior-like scores for new data, based on:
\itemize{
\item \strong{LDA approach} (\code{method="lda"}), which uses a linear discriminant
formula with a pooled covariance matrix if \code{x\$Sigma} is given, or
the identity matrix if \code{Sigma=NULL}. If that covariance matrix is
not invertible, a pseudo-inverse is used and a warning is emitted.
\item \strong{Euclid approach} (\code{method="euclid"}), which uses plain
Euclidean distance to each class mean in the subspace.
}

We return either a \code{type="class"} label or \code{type="prob"} posterior-like
matrix.

If \code{type="class"}, a factor vector of length n (predicted classes).
If \code{type="prob"}, an (n x #classes) numeric matrix of posterior-like values.
}
\description{
This produces class predictions or posterior-like scores for new data. We first
project the data into the subspace defined by \code{x$v}, then either:
\enumerate{
\item \strong{LDA approach} (\code{method="lda"}), which uses a (simplified)
linear discriminant formula or distance to class means in the subspace
combined with prior probabilities.
\item \strong{Euclid approach} (\code{method="euclid"}), which uses plain
Euclidean distance to each class mean in the subspace.
}
We return either a \code{type="class"} label or \code{type="prob"} posterior-like
matrix.
}
