% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellformedness.R
\name{iswellformed}
\alias{iswellformed}
\title{Well-formedness, Myhill's property, and/or moment of symmetry}
\usage{
iswellformed(set, stepword = NULL, allow_de = FALSE, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{stepword}{A vector representing the ranked step sizes of a scale (e.g.
\code{c(2, 2, 1, 2, 2, 2, 1)} for the diatonic). The distinct values of the \code{setword}
should be consecutive integers. If you want to test a step word instead of
a list of pitch classes, \code{set} must be entered as \code{NULL}.}

\item{allow_de}{Should the function test for degenerate well-formed and distributionally even scales too?
Defaults to \code{FALSE}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Boolean answering "Is the scale MOS (with equivalence interval equal to
the period)?" (if allow_de=FALSE) or "Is the scale well-formed
in any sense?" (if allow_de=TRUE).
}
\description{
Tests whether a scale has the property of "well-formedness" or "moment of symmetry."
}
\details{
The three concepts of "well-formedness," "Myhill's property," and "moment of symmetry"
refer to nearly the same scalar property, generalizing one of the most important features
of the familiar diatonic scale. See Clough, Engebretsen, and Kochavi (1999, 77;
\doi{doi:10.2307/745921}) for a useful discussion of their relationships. In short,
except for a few edge cases, a scale possesses these properties if it is generated by copies
of a single interval (as the Pythagorean diatonic is generated by the ratio 3:2) and all copies
of the generator belong to the same generic interval (as the 3:2 generator of the diatonic
always corresponds to a "fifth" within the scale). Such a structure typically means that
all generic intervals come in 2 distinct sizes, which is the definition of "Myhill's property."
An exception occurs if the generator manages to produce a perfectly even scale, e.g. when
the whole tone scale is generated by 6 copies of \code{1/6} of the octave. Such a scale lacks
Myhill's property and Carey & Clampitt (1989, 200; \doi{doi:10.2307/745935}) call such cases
"degenerate well-formed." Instead of Myhill's property, such scales have only 1 specific value
in each \code{\link[=intervalspectrum]{intervalspectrum()}}.

Clough, Engebretsen, and Kochavi define a related concept, distributionally even scales,
which include the hexatonic and octatonic scales (Forte sc6-20 and sc8-28). Such scales are in
some sense halfway between "degenerate" and "non-degenerate well-formed" because some of their
interval spectra have 1 element while others have 2. From another perspective, distributionally
even scales are non-degenerate well formed with a period smaller than the octave (e.g. as the
hexatonic scales 1-3 step pattern repeats every third of an octave).

The term "moment of symmetry" refers to the non-degenerate well-formed scales and was coined by
Erv Wilson 1975 (cited in Clough, Engebretsen, and Kochavi). It tends to be more widely used in
microtonal music theory.

Scales with this property have considerably interesting voice-leading properties and are
some of the most important landmarks in the geometry of MCT. See "Modal Color Theory," pp. 14, 17,
29, 33-34, and 36-37. A substantial portion of MCT amounts to an attempt to generalize ideas developed
for MOS/NDWF scales to all scale structures.
}
\examples{
iswellformed(sc(7, 35))
iswellformed(c(0, 2, 4, 6))
iswellformed(c(0, 1, 6, 7))
iswellformed(c(0, 1, 6, 7), allow_de=TRUE)
iswellformed(NULL, stepword=c(2, 2, 1, 2, 1, 2, 1))
}
