% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mvTweedie.R
\name{predict.mvtweedie}
\alias{predict.mvtweedie}
\title{Predict proportions for new data}
\usage{
\method{predict}{mvtweedie}(object, category_name = "group", newdata, se.fit = FALSE, ...)
}
\arguments{
\item{object}{output from \code{\link[mgcv]{gam}} or \code{\link[glmmTMB]{glmmTMB}}, but with
\code{class(object)=c("mvtweedie",...)} where \code{...} indicates the original values for
\code{class(object)}}

\item{category_name}{name of column that indicates grouping variable}

\item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}

\item{se.fit}{Whether to approximate the standard errors for predicted proportions}

\item{...}{Not used}
}
\value{
predict.mvtweedie produces a vector of predicted proportions or a list containing
predicted proportions and standard errors.
}
\description{
Predict proportions and associated standard errors using a standard S3 object interface
}
\details{
After fitting Tweedie GLM using a log-link and multiple categories, we
transform predicted densities to yield predicted proportions and associated SEs.
This estimator for proportions arises naturally when analyzing a double-marked
point process for diet samples, with marks for category and size.

\code{predict.mvtweedie} does this transformation for a model fitted using:
\itemize{
\item A generalized additive model (GAM) using \code{\link[mgcv]{gam}}
\item A generalized linear mixed model (GLMM) using \code{\link[glmmTMB]{glmmTMB}}
\item A spatio-temporal generalized linear mixed model (GLMM) using \code{\link[tinyVAST]{tinyVAST}}
}
It then also calculates an approximation to the standard error for this proportion.
Specifically, we calculate the proportion for each category as the density \eqn{X}
for that category, and the sum of densities \eqn{Y} for all other categories:

\deqn{ p_X = \frac{X}{X+Y} }

Assuming we have an estimator for the standard error \eqn{s(X)} and \eqn{s(Y)},
and assuming that those estimators are independent such that
\eqn{s(X+Y)^2 = s(X)^2 + s(Y)^2 }, we then apply the
delta method to approximate the standard
error for the proportion as:

\deqn{ s(p_X)^2 = \frac{X^2}{(X+Y)^2} \left( \frac{s(X)^2}{X^2} - 
             2\frac{s(X)^2}{X(X+Y)}+ 
             \frac{s(X)^2 + s(Y)^2}{(X+Y)^2} \right) }

Predictions \eqn{X} and \eqn{Y}, and standard errors \eqn{s(X)} and \eqn{s(Y)}
are then supplied by the \code{predict} function that is native to the software
used when fitting the model.
}
\examples{
\dontshow{if (require("mgcv", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Load packages
library(mvtweedie)
library(mgcv)

# load data set
data( Middleton_Island_TUPU, package="mvtweedie" )

# Run Tweedie GLM
gam0 = gam(
  formula = Response ~ 0 + group,
  data = Middleton_Island_TUPU,
  family = tw
)

# Inspect results
class(gam0) = c( "mvtweedie", class(gam0) )
predict(
  gam0,
  se.fit = TRUE
)
\dontshow{\}) # examplesIf}
}
