% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuroslice.R
\name{NeuroSlice}
\alias{NeuroSlice}
\title{NeuroSlice: 2D Neuroimaging Data Container}
\usage{
NeuroSlice(data, space, indices = NULL)
}
\arguments{
\item{data}{A vector or matrix containing the slice data values.}

\item{space}{An object of class \code{\linkS4class{NeuroSpace}} defining the spatial
properties (dimensions, spacing, origin) of the slice.}

\item{indices}{Optional integer vector. When \code{data} is provided as a 1D vector,
\code{indices} specifies the linear indices where the data values should be placed
in the 2D slice. Useful for creating sparse slices. Default is NULL.}
}
\value{
A new object of class \code{\linkS4class{NeuroSlice}}.
}
\description{
Creates a \code{NeuroSlice} object representing a two-dimensional slice of neuroimaging data
with associated spatial information. This class is particularly useful for working with
individual slices from volumetric neuroimaging data or for visualizing 2D cross-sections.
}
\details{
Two-Dimensional Neuroimaging Data Slice
}
\section{Input Validation}{

The function performs several validation checks:
\itemize{
  \item Verifies that \code{space} is 2-dimensional
  \item Ensures data dimensions are compatible with \code{space}
  \item Validates \code{indices} when provided for sparse initialization
}
}

\section{Data Handling}{

The function supports two initialization modes:
\itemize{
  \item Dense mode (indices = NULL):
    \itemize{
      \item Data is reshaped if necessary to match space dimensions
      \item Dimensions must match exactly after reshaping
    }
  \item Sparse mode (indices provided):
    \itemize{
      \item Creates a zero-initialized matrix matching space dimensions
      \item Places data values at specified indices
    }
}
}

\examples{
# Create a 64x64 slice space
slice_space <- NeuroSpace(c(64, 64), spacing = c(2, 2))

# Example 1: Dense slice from matrix
slice_data <- matrix(rnorm(64*64), 64, 64)
dense_slice <- NeuroSlice(slice_data, slice_space)

# Example 2: Dense slice from vector
vec_data <- rnorm(64*64)
vec_slice <- NeuroSlice(vec_data, slice_space)

# Example 3: Sparse slice with specific values
n_points <- 100
sparse_data <- rnorm(n_points)
sparse_indices <- sample(1:(64*64), n_points)
sparse_slice <- NeuroSlice(sparse_data, slice_space, indices = sparse_indices)

}
\seealso{
\code{\linkS4class{NeuroSpace}} for defining spatial properties,
\code{\linkS4class{NeuroVol}} for 3D volumetric data,
\code{\link{plot}} for visualization methods
}
