% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spat_filter.R
\name{bilateral_filter}
\alias{bilateral_filter}
\title{Apply a bilateral filter to a volumetric image}
\usage{
bilateral_filter(vol, mask, spatial_sigma = 2, intensity_sigma = 1, window = 1)
}
\arguments{
\item{vol}{A \code{\linkS4class{NeuroVol}} object representing the image volume to be smoothed.}

\item{mask}{An optional \code{\linkS4class{LogicalNeuroVol}} object representing the image mask that defines the region where the filtering is applied. If not provided, the entire volume is considered.}

\item{spatial_sigma}{A numeric value specifying the standard deviation of the spatial Gaussian kernel (default is 2).}

\item{intensity_sigma}{A numeric value specifying the standard deviation of the intensity Gaussian kernel (default is 25).}

\item{window}{An integer specifying the number of voxels around the center voxel to include on each side. For example, window=1 for a 3x3x3 kernel (default is 1).}
}
\value{
A smoothed image of class \code{\linkS4class{NeuroVol}}.
}
\description{
This function smooths a volumetric image (3D brain MRI data) using a bilateral filter.
The bilateral filter considers both spatial closeness and intensity similarity for smoothing.
}
\examples{
brain_mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Apply bilateral filtering to the brain volume
filtered_vol <- bilateral_filter(brain_mask, brain_mask, spatial_sigma = 2,
intensity_sigma = 25, window = 1)

}
