% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{which_dim}
\alias{which_dim}
\alias{which_dim,NeuroSpace,NamedAxis-method}
\title{Find Dimensions of a Given Axis}
\usage{
which_dim(x, axis)

\S4method{which_dim}{NeuroSpace,NamedAxis}(x, axis)
}
\arguments{
\item{x}{The NeuroSpace object}

\item{axis}{The NamedAxis to find}
}
\value{
An integer representing the dimension index of the specified \code{axis} for the object \code{x}.
}
\description{
This function returns the dimension of the specified axis for a given object, such as a matrix or an array.
}
\examples{

x <- NeuroSpace(c(10,10,10), spacing=c(1,1,1))
which_dim(x, x@axes@j) == 2
}
