% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R
\docType{data}
\name{NiftiExtensionCodes}
\alias{NiftiExtensionCodes}
\title{Known NIfTI Extension Codes}
\format{
Named integer vector where names describe the extension type:
\describe{
  \item{ignore}{0 - Unknown/private format (not recommended)}
  \item{DICOM}{2 - DICOM format (attribute tags and values)}
  \item{AFNI}{4 - AFNI group (ASCII XML attributes)}
  \item{comment}{6 - Plain text comment}
  \item{XCEDE}{8 - XCEDE format}
  \item{jimdiminfo}{10 - JIM dimension info}
  \item{workflow_fwds}{12 - Workflow forwards}
  \item{FreeSurfer}{14 - FreeSurfer format}
  \item{pypickle}{16 - Python pickle}
  \item{MiND_ident}{18 - MiND identifier}
  \item{b_value}{20 - B-value (diffusion)}
  \item{spherical_direction}{22 - Spherical direction}
  \item{DT_component}{24 - DT component}
  \item{SHC_degreeorder}{26 - SHC degree order}
  \item{voxbo}{28 - VoxBo format}
  \item{Caret}{30 - Caret format}
  \item{CIFTI}{32 - CIFTI format}
  \item{variable_frame_timing}{34 - Variable frame timing}
  \item{eval}{38 - Eval}
  \item{MATLAB}{40 - MATLAB format}
  \item{Quantiphyse}{42 - Quantiphyse}
  \item{MRS}{44 - MRS NIfTI}
}
}
\usage{
NiftiExtensionCodes
}
\description{
A named integer vector of registered NIfTI extension codes.
These codes identify the format/type of extension data.
}
\examples{
# Get the code for AFNI extensions
NiftiExtensionCodes["AFNI"]  # Returns 4

# Get the name for a code
names(NiftiExtensionCodes)[NiftiExtensionCodes == 4]  # Returns "AFNI"

}
\keyword{datasets}
