% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{Summary-methods}
\alias{Summary-methods}
\alias{Summary,SparseNeuroVec-method}
\alias{Summary,SparseNeuroVol-method}
\alias{Summary,DenseNeuroVol-method}
\title{Summary Methods for Neuroimaging Objects}
\usage{
\S4method{Summary}{SparseNeuroVec}(x, ..., na.rm = FALSE)

\S4method{Summary}{SparseNeuroVol}(x, ..., na.rm = FALSE)

\S4method{Summary}{DenseNeuroVol}(x, ..., na.rm = FALSE)

\S4method{Summary}{DenseNeuroVol}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A neuroimaging object (SparseNeuroVec, SparseNeuroVol, or DenseNeuroVol)}

\item{...}{Additional arguments passed to methods}

\item{na.rm}{Logical indicating whether to remove NA values before computation}
}
\value{
The result of the summary operation
}
\description{
Methods for the \code{Summary} group generic (e.g., \code{sum}, \code{min},
\code{max}, \code{range}, \code{prod}, \code{any}, \code{all}) applied to
neuroimaging data objects.
}
\examples{
# Create a simple volume
vol <- DenseNeuroVol(array(1:27, c(3,3,3)),
                     NeuroSpace(c(3L,3L,3L), c(1,1,1)))
sum(vol)
range(vol)

}
