% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Team.R
\name{team_month_schedule}
\alias{team_month_schedule}
\title{Access the schedule for a team and month}
\usage{
team_month_schedule(team = 1, month = "now")
}
\arguments{
\item{team}{integer ID (e.g., 21), character full name (e.g., 'Colorado
Avalanche'), OR three-letter code (e.g., 'COL'); see \code{\link[=teams]{teams()}} for
reference; ID is preferable as there now exists duplicate three-letter codes
(i.e., 'UTA' for 'Utah Hockey Club' and 'Utah Mammoth')}

\item{month}{character in 'YYYY-MM' (e.g., '2025-01'); see \code{\link[=seasons]{seasons()}}
for reference}
}
\value{
data.frame with one row per game
}
\description{
\code{team_month_schedule()} scrapes the schedule for a given set of \code{team}
and \code{month}.
}
\examples{
COL_schedule_December_2025 <- team_month_schedule(
  team  = 21, 
  month = '2025-12'
)
}
