% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{param.bounds}
\alias{param.bounds}
\title{Define Parameter Bounds for PK Models}
\usage{
param.bounds(
  theta = list(lower = NULL, upper = NULL),
  omega = list(lower = NULL, upper = NULL),
  sigma = list(add = list(lower = 0.001, upper = Inf), prop = list(lower = 0.001, upper =
    Inf)),
  correlation = list(lower = 0.1, upper = 0.8)
)
}
\arguments{
\item{theta}{A list with optional elements:
\describe{
\item{lower}{Named list of lower bounds for fixed effects. Defaults to
-Inf for all parameters.}
\item{upper}{Named list of upper bounds for fixed effects. Defaults to
10^9 for all parameters.}
}}

\item{omega}{A list with optional elements:
\describe{
\item{lower}{Named list of lower bounds for variance terms. Defaults to
10 for all parameters.}
\item{upper}{Named list of upper bounds for variance terms. Defaults to
Inf for all parameters.}
}}

\item{sigma}{A list with two elements (each itself a list of bounds):
\describe{
\item{add}{Lower and upper bounds for additive error component.
Defaults to 0.001 and Inf.}
\item{prop}{Lower and upper bounds for proportional error component.
Defaults to 0.001 and Inf.}
}}

\item{correlation}{A list with elements lower and upper
giving the bounds for correlation terms. Defaults to 0.1 and 0.8.}
}
\value{
A named list with four components:
\describe{
\item{theta}{List of parameter-specific lower and upper bounds
for fixed effects.}
\item{omega}{List of lower and upper bounds for variance terms.}
\item{sigma}{List with additive (add) and proportional (prop)
error bounds.}
\item{correlation}{List with lower and upper correlation bounds.}
}
}
\description{
Utility function to generate lower and upper bounds for
pharmacokinetic model parameters, including fixed effects (theta),
random effects variances (omega), residual error (sigma),
and correlation constraints.
}
\details{
Default theta bounds use -Inf for lower limits and 10^9 for upper limits
to avoid allowing unrealistically large fixed effect estimates while
still providing flexibility during model estimation.
}
\examples{
# Use all default bounds
 param.bounds()

# Customize only omega lower bounds
param.bounds(omega = list(lower = list(cl = 5, vc = 2)))

# Adjust sigma proportional error bounds
param.bounds(
  sigma = list(
    add = list(lower = 0.001, upper = 1),
    prop = list(lower = 0.01, upper = 0.05)
  )
)

}
\author{
Zhonghui Huang
}
