% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{obm_put}
\alias{obm_put}
\title{Put data unsing obm forms}
\usage{
obm_put(
  scope = NULL,
  form_header = NULL,
  data_file = NULL,
  media_file = NULL,
  form_id = "",
  form_data = "",
  soft_error = "",
  data_table = NULL
)
}
\arguments{
\item{scope}{currently put_data supported.}

\item{form_header}{database column names vector, if missing default is the full list from the form}

\item{data_file}{a csv file with header row (API v2)}

\item{media_file}{a media file to attach}

\item{form_id}{the form's id}

\item{form_data}{JSON array or data.frame of data. In v3, only the first row of a data.frame is uploaded.}

\item{soft_error}{JSON array of 'Yes' strings (or translations of it) to skip soft error messages (API v2)}

\item{data_table}{a database table name}
}
\value{
json or boolean
}
\description{
This function allows put data into an OpenBioMaps server.
For API v3 (api_version >= 3.0), 'put_data' is supported.
Note: In API v3, 'put_data' currently supports single observation upload only.
}
\details{
The following code *illustrates* how you could use this function in practice,
but it is **not meant to be run directly** (e.g., depends on external data).

\preformatted{
# Using own list of columns
results <- obm_get('get_form_list')
form_id <- results$form_id[1] # e.g. 57

response <- obm_put('put_data',columns[1:3],form_id=form_id,data_file='examples/test_upload.csv')

# Using default columns list:
response <- obm_put(scope='put_data',form_id=57,csv_file='examples/test_upload.csv')

# JSON upload
data <- matrix(c(
                 c("Tringa totanus",'egyed',"AWBO",'10','POINT(47.1 21.3)'),
                 c("Tringa flavipes",'egyed',"BYWO",'2','POINT(47.3 21.4)')
               ),ncol=5,nrow=2,byrow=TRUE)
colnames(data)<-c("species","numerosity","location","quantity","geometry")

response <- obm_put(
               scope='put_data',
               form_id=57,
               form_data=as.data.frame(data),
               form_header=c('faj','szamossag','hely','egyedszam'))

# With attached files
data <- matrix(c(c("Tringa totanus",'egyed',"AWBO",'10','numbers.odt'),
                 c("Tringa flavipes",'egyed',"BYWO",'2','observation.jpg')
               ),ncol=5,nrow=2,byrow=TRUE)
colnames(data)<-c("species","numerosity","location","quantity",'Attach')

response <- obm_put(
               scope='put_data',
               form_id=57,
               form_data=as.data.frame(data),
               form_header=c('species','numerosity','location','quantity','obm_files_id'),
               media_file=c('examples/numbers.odt','examples/observation.jpg'))
}
}
\examples{
\donttest{
csv_path <- system.file("examples/test_upload.csv", package = "obm")
csv_data <- read.csv(csv_path)
columns <- names(csv_data)
response <- obm_put('put_data',columns[1:3],form_id=57,data_file='examples/test_upload.csv')
}

}
\keyword{put}
\keyword{upload}
