% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hal_query.R
\name{hal_query}
\alias{hal_query}
\title{Build Query}
\usage{
hal_query(value = "*", field = "text", ...)
}
\arguments{
\item{value}{A \code{\link{vector}} giving the topics to be searched for (see details).}

\item{field}{A \code{\link{character}} string specifying the field to search within.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{list}} of class \code{HALQuery} containing at least the following components:
\describe{
\item{\code{q}}{(default to "\verb{text:*}").}
\item{\code{fl}}{default to "\verb{docid,label_s}").}
\item{\code{wt}}{(default to "\code{json}").}
}
}
\description{
Initialize a query to the HAL API.
}
\examples{
## Search for 'asie' in the 'text' field
hal_query("asie")

## Search for 'japon' and 'france' in the 'title_t' field
term <- list("japon", "france")
hal_query(term, field = "title_t")

## Search for 'Journal', and 'Histoire' or 'History' in the 'title_t' field
term <- list("Journal", c("Histoire", "History"))
hal_query(term, field = "title_t")
}
\seealso{
Other query tools: 
\code{\link{hal_facet}()},
\code{\link{hal_filter}()},
\code{\link{hal_group}()},
\code{\link{hal_select}()},
\code{\link{hal_sort}()},
\code{\link{operators}}
}
\author{
N. Frerebeau
}
\concept{query tools}
