% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{floating_external_img}
\alias{floating_external_img}
\title{Floating external image}
\usage{
floating_external_img(
  src,
  width = 0.5,
  height = 0.2,
  pos_x = 0,
  pos_y = 0,
  pos_h_from = "margin",
  pos_v_from = "margin",
  wrap_type = "square",
  wrap_side = "bothSides",
  wrap_dist_top = 0,
  wrap_dist_bottom = 0,
  wrap_dist_left = 0.125,
  wrap_dist_right = 0.125,
  unit = "in",
  guess_size = FALSE,
  alt = ""
)
}
\arguments{
\item{src}{image file path}

\item{width, height}{size of the image file. It can be ignored
if parameter \code{guess_size=TRUE}, see parameter \code{guess_size}.}

\item{pos_x, pos_y}{horizontal and vertical position of the image relative to the anchor point}

\item{pos_h_from}{horizontal positioning reference point, one of "margin", "page", "column", "character"}

\item{pos_v_from}{vertical positioning reference point, one of "margin", "page", "paragraph", "line"}

\item{wrap_type}{text wrapping type, one of "square", "topAndBottom", "through", "tight", "none"}

\item{wrap_side}{which side text wraps around, one of "bothSides", "left", "right", "largest"}

\item{wrap_dist_top, wrap_dist_bottom, wrap_dist_left, wrap_dist_right}{distance between image and text (in inches)}

\item{unit}{unit for width, height, pos_x and pos_y, one of "in", "cm", "mm".}

\item{guess_size}{If package 'magick' is installed, this option
can be used (set it to \code{TRUE}). The images will be read and
width and height will be guessed.}

\item{alt}{alternative text for images}
}
\description{
Wraps an image in an object that can be embedded as a floating
image in a 'Word' document. Unlike \code{\link[=external_img]{external_img()}}, which creates inline images,
this function creates floating images that can be positioned anywhere on the page
and allow text wrapping around them.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{
library(officer)
srcfile <- file.path(R.home("doc"), "html", "logo.jpg")
floatimg <- floating_external_img(
  src = srcfile, height = 1.06 / 2, width = 1.39 / 2,
  pos_x = 0, pos_y = 0,
  pos_h_from = "margin", pos_v_from = "margin"
)

text <- paste0(
  " is a floating image in a ",
  paste0(rep("very ", 30), collapse = ""),
  " long text!"
)

# docx example ----
x <- read_docx()
fp_t <- fp_text(font.size = 20, color = "red")
an_fpar <- fpar(floatimg, ftext(text, fp_t))
x <- body_add_fpar(x, an_fpar)
print(x, target = tempfile(fileext = ".docx"))

# rtf example ----
rtf_doc <- rtf_doc()
rtf_doc <- rtf_add(rtf_doc, an_fpar)
print(rtf_doc, target = tempfile(fileext = ".rtf"))
}
\seealso{
\link{external_img}, \link{body_add}, \link{fpar}, \link{rtf_doc}, \link{rtf_add}

Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_comment}()},
\code{\link{run_footnote}()},
\code{\link{run_footnoteref}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_tab}()},
\code{\link{run_word_field}()},
\code{\link{run_wordtext}()}
}
\concept{run functions for reporting}
