% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Instance.R
\name{Instance}
\alias{Instance}
\title{DICOM Instance Class}
\value{
An R6 instance of class \code{"Instance"}.
}
\description{
An abstract class for a DICOM Instance resource.
}
\section{Super class}{
\code{\link[orthanc:Resource]{orthanc::Resource}} -> \code{Instance}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{uid}}{SOPInstanceUID}

\item{\code{file_size}}{File size}

\item{\code{creation_date}}{Creation Date}

\item{\code{series_identifier}}{Parent series identifier}

\item{\code{parent_series}}{Parent series}

\item{\code{parent_study}}{Parent study}

\item{\code{parent_patient}}{Parent patient}

\item{\code{acquisition_number}}{Acquisition Number}

\item{\code{image_index}}{Image Index}

\item{\code{image_orientation_patient}}{Image Orientation Patient}

\item{\code{image_position_patient}}{Image Position Patient}

\item{\code{image_comments}}{Image Comments}

\item{\code{instance_number}}{Instance Number}

\item{\code{number_of_frames}}{Number of Frames}

\item{\code{temporal_position_identifier}}{Temporal Position Identifier}

\item{\code{tags}}{Tags}

\item{\code{simplified_tags}}{Simplified Tags}

\item{\code{labels}}{Labels}

\item{\code{statistics}}{Statistics}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Instance-get_dicom_file_content}{\code{Instance$get_dicom_file_content()}}
\item \href{#method-Instance-download}{\code{Instance$download()}}
\item \href{#method-Instance-get_main_information}{\code{Instance$get_main_information()}}
\item \href{#method-Instance-add_label}{\code{Instance$add_label()}}
\item \href{#method-Instance-remove_label}{\code{Instance$remove_label()}}
\item \href{#method-Instance-get_content_by_tag}{\code{Instance$get_content_by_tag()}}
\item \href{#method-Instance-anonymize}{\code{Instance$anonymize()}}
\item \href{#method-Instance-modify}{\code{Instance$modify()}}
\item \href{#method-Instance-download_nifti}{\code{Instance$download_nifti()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Resource" data-id="initialize"><a href='../../orthanc/html/Resource.html#method-Resource-initialize'><code>orthanc::Resource$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Resource" data-id="print"><a href='../../orthanc/html/Resource.html#method-Resource-print'><code>orthanc::Resource$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Resource" data-id="set_child_resources"><a href='../../orthanc/html/Resource.html#method-Resource-set_child_resources'><code>orthanc::Resource$set_child_resources()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_dicom_file_content"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_dicom_file_content}{}}}
\subsection{Method \code{get_dicom_file_content()}}{
Retrieves DICOM file

This method retrieves bytes corresponding to DICOM file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_dicom_file_content()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-download"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-download}{}}}
\subsection{Method \code{download()}}{
Download DICOM file to a path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$download(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File path on disk.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_main_information"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_main_information}{}}}
\subsection{Method \code{get_main_information()}}{
Get instance information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_main_information()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-add_label"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-add_label}{}}}
\subsection{Method \code{add_label()}}{
Add label to resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$add_label(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Label.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-remove_label"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-remove_label}{}}}
\subsection{Method \code{remove_label()}}{
Delete label from resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$remove_label(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Label.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_content_by_tag"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_content_by_tag}{}}}
\subsection{Method \code{get_content_by_tag()}}{
Get content by tag.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_content_by_tag(tag)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tag}}{tag.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-anonymize"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-anonymize}{}}}
\subsection{Method \code{anonymize()}}{
Anonymize Instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$anonymize(
  remove = list(),
  replace = list(),
  keep = list(),
  keep_private_tags = FALSE,
  keep_source = TRUE,
  private_creator = NULL,
  force = FALSE,
  dicom_version = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove}}{List of tags to remove.}

\item{\code{replace}}{Named-list of tags to replce.}

\item{\code{keep}}{List of tags to keep unchanged.}

\item{\code{keep_private_tags}}{Keep private tags from DICOM instance.}

\item{\code{keep_source}}{Keep original resource.}

\item{\code{private_creator}}{Private creator to be used for private tags in
replace.}

\item{\code{force}}{Force tags to be changed.}

\item{\code{dicom_version}}{Version of the DICOM standard to use for
anonymization.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-modify"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-modify}{}}}
\subsection{Method \code{modify()}}{
Modify an Instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$modify(
  remove = list(),
  replace = list(),
  keep = list(),
  remove_private_tags = FALSE,
  keep_source = TRUE,
  private_creator = NULL,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove}}{List of tags to remove.}

\item{\code{replace}}{Named-list of tags to replce.}

\item{\code{keep}}{List of tags to keep unchanged.}

\item{\code{remove_private_tags}}{Remove private tags from DICOM instance.}

\item{\code{keep_source}}{Keep original resource.}

\item{\code{private_creator}}{Private creator to be used for private tags in
replace.}

\item{\code{force}}{Force tags to be changed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-download_nifti"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-download_nifti}{}}}
\subsection{Method \code{download_nifti()}}{
Download instance as NIfTI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$download_nifti(path, compress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path on disk.}

\item{\code{compress}}{Compress to gzip.}
}
\if{html}{\out{</div>}}
}
}
}
