% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrthancAsync.R
\name{OrthancAsync}
\alias{OrthancAsync}
\title{Asynchronous Orthanc API Client}
\value{
An \code{OrthancAsync} instance.
}
\description{
Orthanc is an open-source, lightweight DICOM server for healthcare and
medical research. This \code{R6} generator creates a client to access
Orthanc's RESTful API. More details about the Orthanc REST API can be
found here: \url{https://orthanc.uclouvain.be/book/users/rest.html}.

The full documentation of the Orthanc API can be found here:
\url{https://orthanc.uclouvain.be/api/}.
}
\details{
See \link{Orthanc} for more information.
}
\section{Super class}{
\code{\link[orthanc:Orthanc]{orthanc::Orthanc}} -> \code{OrthancAsync}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OrthancAsync-print}{\code{OrthancAsync$print()}}
\item \href{#method-OrthancAsync-clone}{\code{OrthancAsync$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="DELETE"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-DELETE'><code>orthanc::Orthanc$DELETE()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="GET"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-GET'><code>orthanc::Orthanc$GET()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="POST"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-POST'><code>orthanc::Orthanc$POST()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="PUT"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-PUT'><code>orthanc::Orthanc$PUT()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_changes"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_changes'><code>orthanc::Orthanc$delete_changes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_exports"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_exports'><code>orthanc::Orthanc$delete_exports()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_instances_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_instances_id'><code>orthanc::Orthanc$delete_instances_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_instances_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_instances_id_attachments_name'><code>orthanc::Orthanc$delete_instances_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_instances_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_instances_id_labels_label'><code>orthanc::Orthanc$delete_instances_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_instances_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_instances_id_metadata_name'><code>orthanc::Orthanc$delete_instances_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_jobs_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_jobs_id'><code>orthanc::Orthanc$delete_jobs_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_jobs_id_key"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_jobs_id_key'><code>orthanc::Orthanc$delete_jobs_id_key()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_modalities_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_modalities_id'><code>orthanc::Orthanc$delete_modalities_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_patients_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_patients_id'><code>orthanc::Orthanc$delete_patients_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_patients_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_patients_id_attachments_name'><code>orthanc::Orthanc$delete_patients_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_patients_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_patients_id_labels_label'><code>orthanc::Orthanc$delete_patients_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_patients_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_patients_id_metadata_name'><code>orthanc::Orthanc$delete_patients_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_peers_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_peers_id'><code>orthanc::Orthanc$delete_peers_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_queries_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_queries_id'><code>orthanc::Orthanc$delete_queries_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_series_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_series_id'><code>orthanc::Orthanc$delete_series_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_series_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_series_id_attachments_name'><code>orthanc::Orthanc$delete_series_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_series_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_series_id_labels_label'><code>orthanc::Orthanc$delete_series_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_series_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_series_id_metadata_name'><code>orthanc::Orthanc$delete_series_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_studies_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_studies_id'><code>orthanc::Orthanc$delete_studies_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_studies_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_studies_id_attachments_name'><code>orthanc::Orthanc$delete_studies_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_studies_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_studies_id_labels_label'><code>orthanc::Orthanc$delete_studies_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="delete_studies_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-delete_studies_id_metadata_name'><code>orthanc::Orthanc$delete_studies_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_changes"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_changes'><code>orthanc::Orthanc$get_changes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_exports"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_exports'><code>orthanc::Orthanc$get_exports()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances'><code>orthanc::Orthanc$get_instances()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id'><code>orthanc::Orthanc$get_instances_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments'><code>orthanc::Orthanc$get_instances_id_attachments()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name'><code>orthanc::Orthanc$get_instances_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_compressed_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_compressed_data'><code>orthanc::Orthanc$get_instances_id_attachments_name_compressed_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_compressed_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_compressed_md5'><code>orthanc::Orthanc$get_instances_id_attachments_name_compressed_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_compressed_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_compressed_size'><code>orthanc::Orthanc$get_instances_id_attachments_name_compressed_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_data'><code>orthanc::Orthanc$get_instances_id_attachments_name_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_info"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_info'><code>orthanc::Orthanc$get_instances_id_attachments_name_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_is_compressed"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_is_compressed'><code>orthanc::Orthanc$get_instances_id_attachments_name_is_compressed()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_md5'><code>orthanc::Orthanc$get_instances_id_attachments_name_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_attachments_name_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_attachments_name_size'><code>orthanc::Orthanc$get_instances_id_attachments_name_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_content_path"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_content_path'><code>orthanc::Orthanc$get_instances_id_content_path()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_file"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_file'><code>orthanc::Orthanc$get_instances_id_file()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames'><code>orthanc::Orthanc$get_instances_id_frames()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame'><code>orthanc::Orthanc$get_instances_id_frames_frame()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_image_int16"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_image_int16'><code>orthanc::Orthanc$get_instances_id_frames_frame_image_int16()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_image_uint16"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_image_uint16'><code>orthanc::Orthanc$get_instances_id_frames_frame_image_uint16()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_image_uint8"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_image_uint8'><code>orthanc::Orthanc$get_instances_id_frames_frame_image_uint8()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_matlab"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_matlab'><code>orthanc::Orthanc$get_instances_id_frames_frame_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_numpy"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_numpy'><code>orthanc::Orthanc$get_instances_id_frames_frame_numpy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_preview"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_preview'><code>orthanc::Orthanc$get_instances_id_frames_frame_preview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_raw"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_raw'><code>orthanc::Orthanc$get_instances_id_frames_frame_raw()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_raw.gz"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_raw.gz'><code>orthanc::Orthanc$get_instances_id_frames_frame_raw.gz()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_frames_frame_rendered"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_frames_frame_rendered'><code>orthanc::Orthanc$get_instances_id_frames_frame_rendered()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_header"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_header'><code>orthanc::Orthanc$get_instances_id_header()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_image_int16"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_image_int16'><code>orthanc::Orthanc$get_instances_id_image_int16()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_image_uint16"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_image_uint16'><code>orthanc::Orthanc$get_instances_id_image_uint16()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_image_uint8"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_image_uint8'><code>orthanc::Orthanc$get_instances_id_image_uint8()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_labels"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_labels'><code>orthanc::Orthanc$get_instances_id_labels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_labels_label'><code>orthanc::Orthanc$get_instances_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_matlab"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_matlab'><code>orthanc::Orthanc$get_instances_id_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_metadata"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_metadata'><code>orthanc::Orthanc$get_instances_id_metadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_metadata_name'><code>orthanc::Orthanc$get_instances_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_module"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_module'><code>orthanc::Orthanc$get_instances_id_module()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_numpy"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_numpy'><code>orthanc::Orthanc$get_instances_id_numpy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_patient"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_patient'><code>orthanc::Orthanc$get_instances_id_patient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_pdf"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_pdf'><code>orthanc::Orthanc$get_instances_id_pdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_preview"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_preview'><code>orthanc::Orthanc$get_instances_id_preview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_rendered"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_rendered'><code>orthanc::Orthanc$get_instances_id_rendered()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_series"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_series'><code>orthanc::Orthanc$get_instances_id_series()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_simplified_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_simplified_tags'><code>orthanc::Orthanc$get_instances_id_simplified_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_statistics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_statistics'><code>orthanc::Orthanc$get_instances_id_statistics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_study"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_study'><code>orthanc::Orthanc$get_instances_id_study()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_instances_id_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_instances_id_tags'><code>orthanc::Orthanc$get_instances_id_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_jobs"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_jobs'><code>orthanc::Orthanc$get_jobs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_jobs_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_jobs_id'><code>orthanc::Orthanc$get_jobs_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_jobs_id_key"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_jobs_id_key'><code>orthanc::Orthanc$get_jobs_id_key()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_modalities"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_modalities'><code>orthanc::Orthanc$get_modalities()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_modalities_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_modalities_id'><code>orthanc::Orthanc$get_modalities_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_modalities_id_configuration"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_modalities_id_configuration'><code>orthanc::Orthanc$get_modalities_id_configuration()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients'><code>orthanc::Orthanc$get_patients()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id'><code>orthanc::Orthanc$get_patients_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_archive'><code>orthanc::Orthanc$get_patients_id_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments'><code>orthanc::Orthanc$get_patients_id_attachments()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name'><code>orthanc::Orthanc$get_patients_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_compressed_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_compressed_data'><code>orthanc::Orthanc$get_patients_id_attachments_name_compressed_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_compressed_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_compressed_md5'><code>orthanc::Orthanc$get_patients_id_attachments_name_compressed_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_compressed_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_compressed_size'><code>orthanc::Orthanc$get_patients_id_attachments_name_compressed_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_data'><code>orthanc::Orthanc$get_patients_id_attachments_name_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_info"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_info'><code>orthanc::Orthanc$get_patients_id_attachments_name_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_is_compressed"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_is_compressed'><code>orthanc::Orthanc$get_patients_id_attachments_name_is_compressed()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_md5'><code>orthanc::Orthanc$get_patients_id_attachments_name_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_attachments_name_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_attachments_name_size'><code>orthanc::Orthanc$get_patients_id_attachments_name_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_instances"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_instances'><code>orthanc::Orthanc$get_patients_id_instances()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_instances_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_instances_tags'><code>orthanc::Orthanc$get_patients_id_instances_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_labels"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_labels'><code>orthanc::Orthanc$get_patients_id_labels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_labels_label'><code>orthanc::Orthanc$get_patients_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_media'><code>orthanc::Orthanc$get_patients_id_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_metadata"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_metadata'><code>orthanc::Orthanc$get_patients_id_metadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_metadata_name'><code>orthanc::Orthanc$get_patients_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_module"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_module'><code>orthanc::Orthanc$get_patients_id_module()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_protected"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_protected'><code>orthanc::Orthanc$get_patients_id_protected()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_series"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_series'><code>orthanc::Orthanc$get_patients_id_series()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_shared_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_shared_tags'><code>orthanc::Orthanc$get_patients_id_shared_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_statistics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_statistics'><code>orthanc::Orthanc$get_patients_id_statistics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_patients_id_studies"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_patients_id_studies'><code>orthanc::Orthanc$get_patients_id_studies()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_peers"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_peers'><code>orthanc::Orthanc$get_peers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_peers_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_peers_id'><code>orthanc::Orthanc$get_peers_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_peers_id_configuration"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_peers_id_configuration'><code>orthanc::Orthanc$get_peers_id_configuration()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_peers_id_system"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_peers_id_system'><code>orthanc::Orthanc$get_peers_id_system()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_plugins"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_plugins'><code>orthanc::Orthanc$get_plugins()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_plugins_explorer.js"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_plugins_explorer.js'><code>orthanc::Orthanc$get_plugins_explorer.js()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_plugins_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_plugins_id'><code>orthanc::Orthanc$get_plugins_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries'><code>orthanc::Orthanc$get_queries()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id'><code>orthanc::Orthanc$get_queries_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id_answers"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id_answers'><code>orthanc::Orthanc$get_queries_id_answers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id_answers_index"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id_answers_index'><code>orthanc::Orthanc$get_queries_id_answers_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id_answers_index_content"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id_answers_index_content'><code>orthanc::Orthanc$get_queries_id_answers_index_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id_level"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id_level'><code>orthanc::Orthanc$get_queries_id_level()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id_modality"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id_modality'><code>orthanc::Orthanc$get_queries_id_modality()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_queries_id_query"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_queries_id_query'><code>orthanc::Orthanc$get_queries_id_query()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series'><code>orthanc::Orthanc$get_series()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id'><code>orthanc::Orthanc$get_series_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_archive'><code>orthanc::Orthanc$get_series_id_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments'><code>orthanc::Orthanc$get_series_id_attachments()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name'><code>orthanc::Orthanc$get_series_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_compressed_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_compressed_data'><code>orthanc::Orthanc$get_series_id_attachments_name_compressed_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_compressed_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_compressed_md5'><code>orthanc::Orthanc$get_series_id_attachments_name_compressed_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_compressed_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_compressed_size'><code>orthanc::Orthanc$get_series_id_attachments_name_compressed_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_data'><code>orthanc::Orthanc$get_series_id_attachments_name_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_info"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_info'><code>orthanc::Orthanc$get_series_id_attachments_name_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_is_compressed"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_is_compressed'><code>orthanc::Orthanc$get_series_id_attachments_name_is_compressed()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_md5'><code>orthanc::Orthanc$get_series_id_attachments_name_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_attachments_name_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_attachments_name_size'><code>orthanc::Orthanc$get_series_id_attachments_name_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_instances"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_instances'><code>orthanc::Orthanc$get_series_id_instances()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_instances_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_instances_tags'><code>orthanc::Orthanc$get_series_id_instances_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_labels"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_labels'><code>orthanc::Orthanc$get_series_id_labels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_labels_label'><code>orthanc::Orthanc$get_series_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_media'><code>orthanc::Orthanc$get_series_id_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_metadata"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_metadata'><code>orthanc::Orthanc$get_series_id_metadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_metadata_name'><code>orthanc::Orthanc$get_series_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_module"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_module'><code>orthanc::Orthanc$get_series_id_module()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_numpy"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_numpy'><code>orthanc::Orthanc$get_series_id_numpy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_patient"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_patient'><code>orthanc::Orthanc$get_series_id_patient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_shared_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_shared_tags'><code>orthanc::Orthanc$get_series_id_shared_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_statistics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_statistics'><code>orthanc::Orthanc$get_series_id_statistics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_series_id_study"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_series_id_study'><code>orthanc::Orthanc$get_series_id_study()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_statistics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_statistics'><code>orthanc::Orthanc$get_statistics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_storage_commitment_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_storage_commitment_id'><code>orthanc::Orthanc$get_storage_commitment_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies'><code>orthanc::Orthanc$get_studies()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id'><code>orthanc::Orthanc$get_studies_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_archive'><code>orthanc::Orthanc$get_studies_id_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments'><code>orthanc::Orthanc$get_studies_id_attachments()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name'><code>orthanc::Orthanc$get_studies_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_compressed_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_compressed_data'><code>orthanc::Orthanc$get_studies_id_attachments_name_compressed_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_compressed_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_compressed_md5'><code>orthanc::Orthanc$get_studies_id_attachments_name_compressed_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_compressed_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_compressed_size'><code>orthanc::Orthanc$get_studies_id_attachments_name_compressed_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_data"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_data'><code>orthanc::Orthanc$get_studies_id_attachments_name_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_info"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_info'><code>orthanc::Orthanc$get_studies_id_attachments_name_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_is_compressed"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_is_compressed'><code>orthanc::Orthanc$get_studies_id_attachments_name_is_compressed()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_md5'><code>orthanc::Orthanc$get_studies_id_attachments_name_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_attachments_name_size"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_attachments_name_size'><code>orthanc::Orthanc$get_studies_id_attachments_name_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_instances"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_instances'><code>orthanc::Orthanc$get_studies_id_instances()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_instances_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_instances_tags'><code>orthanc::Orthanc$get_studies_id_instances_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_labels"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_labels'><code>orthanc::Orthanc$get_studies_id_labels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_labels_label'><code>orthanc::Orthanc$get_studies_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_media'><code>orthanc::Orthanc$get_studies_id_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_metadata"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_metadata'><code>orthanc::Orthanc$get_studies_id_metadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_metadata_name'><code>orthanc::Orthanc$get_studies_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_module"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_module'><code>orthanc::Orthanc$get_studies_id_module()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_module_patient"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_module_patient'><code>orthanc::Orthanc$get_studies_id_module_patient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_patient"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_patient'><code>orthanc::Orthanc$get_studies_id_patient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_series"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_series'><code>orthanc::Orthanc$get_studies_id_series()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_shared_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_shared_tags'><code>orthanc::Orthanc$get_studies_id_shared_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_studies_id_statistics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_studies_id_statistics'><code>orthanc::Orthanc$get_studies_id_statistics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_system"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_system'><code>orthanc::Orthanc$get_system()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools'><code>orthanc::Orthanc$get_tools()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_accepted_sop_classes"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_accepted_sop_classes'><code>orthanc::Orthanc$get_tools_accepted_sop_classes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_accepted_transfer_syntaxes"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_accepted_transfer_syntaxes'><code>orthanc::Orthanc$get_tools_accepted_transfer_syntaxes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_create_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_create_archive'><code>orthanc::Orthanc$get_tools_create_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_create_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_create_media'><code>orthanc::Orthanc$get_tools_create_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_create_media_extended"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_create_media_extended'><code>orthanc::Orthanc$get_tools_create_media_extended()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_default_encoding"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_default_encoding'><code>orthanc::Orthanc$get_tools_default_encoding()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_dicom_conformance"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_dicom_conformance'><code>orthanc::Orthanc$get_tools_dicom_conformance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_generate_uid"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_generate_uid'><code>orthanc::Orthanc$get_tools_generate_uid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_labels"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_labels'><code>orthanc::Orthanc$get_tools_labels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level'><code>orthanc::Orthanc$get_tools_log_level()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_dicom"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_dicom'><code>orthanc::Orthanc$get_tools_log_level_dicom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_generic"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_generic'><code>orthanc::Orthanc$get_tools_log_level_generic()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_http"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_http'><code>orthanc::Orthanc$get_tools_log_level_http()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_jobs"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_jobs'><code>orthanc::Orthanc$get_tools_log_level_jobs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_lua"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_lua'><code>orthanc::Orthanc$get_tools_log_level_lua()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_plugins"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_plugins'><code>orthanc::Orthanc$get_tools_log_level_plugins()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_log_level_sqlite"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_log_level_sqlite'><code>orthanc::Orthanc$get_tools_log_level_sqlite()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_metrics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_metrics'><code>orthanc::Orthanc$get_tools_metrics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_metrics_prometheus"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_metrics_prometheus'><code>orthanc::Orthanc$get_tools_metrics_prometheus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_now"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_now'><code>orthanc::Orthanc$get_tools_now()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_now_local"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_now_local'><code>orthanc::Orthanc$get_tools_now_local()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="get_tools_unknown_sop_class_accepted"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-get_tools_unknown_sop_class_accepted'><code>orthanc::Orthanc$get_tools_unknown_sop_class_accepted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="initialize"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-initialize'><code>orthanc::Orthanc$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances'><code>orthanc::Orthanc$post_instances()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_anonymize"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_anonymize'><code>orthanc::Orthanc$post_instances_id_anonymize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_attachments_name_compress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_attachments_name_compress'><code>orthanc::Orthanc$post_instances_id_attachments_name_compress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_attachments_name_uncompress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_attachments_name_uncompress'><code>orthanc::Orthanc$post_instances_id_attachments_name_uncompress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_attachments_name_verify_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_attachments_name_verify_md5'><code>orthanc::Orthanc$post_instances_id_attachments_name_verify_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_export"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_export'><code>orthanc::Orthanc$post_instances_id_export()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_modify"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_modify'><code>orthanc::Orthanc$post_instances_id_modify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_instances_id_reconstruct"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_instances_id_reconstruct'><code>orthanc::Orthanc$post_instances_id_reconstruct()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_jobs_id_cancel"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_jobs_id_cancel'><code>orthanc::Orthanc$post_jobs_id_cancel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_jobs_id_pause"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_jobs_id_pause'><code>orthanc::Orthanc$post_jobs_id_pause()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_jobs_id_resubmit"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_jobs_id_resubmit'><code>orthanc::Orthanc$post_jobs_id_resubmit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_jobs_id_resume"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_jobs_id_resume'><code>orthanc::Orthanc$post_jobs_id_resume()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_echo"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_echo'><code>orthanc::Orthanc$post_modalities_id_echo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_find_worklist"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_find_worklist'><code>orthanc::Orthanc$post_modalities_id_find_worklist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_get"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_get'><code>orthanc::Orthanc$post_modalities_id_get()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_move"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_move'><code>orthanc::Orthanc$post_modalities_id_move()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_query"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_query'><code>orthanc::Orthanc$post_modalities_id_query()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_storage_commitment"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_storage_commitment'><code>orthanc::Orthanc$post_modalities_id_storage_commitment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_store"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_store'><code>orthanc::Orthanc$post_modalities_id_store()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_modalities_id_store_straight"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_modalities_id_store_straight'><code>orthanc::Orthanc$post_modalities_id_store_straight()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_anonymize"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_anonymize'><code>orthanc::Orthanc$post_patients_id_anonymize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_archive'><code>orthanc::Orthanc$post_patients_id_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_attachments_name_compress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_attachments_name_compress'><code>orthanc::Orthanc$post_patients_id_attachments_name_compress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_attachments_name_uncompress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_attachments_name_uncompress'><code>orthanc::Orthanc$post_patients_id_attachments_name_uncompress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_attachments_name_verify_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_attachments_name_verify_md5'><code>orthanc::Orthanc$post_patients_id_attachments_name_verify_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_media'><code>orthanc::Orthanc$post_patients_id_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_modify"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_modify'><code>orthanc::Orthanc$post_patients_id_modify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_patients_id_reconstruct"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_patients_id_reconstruct'><code>orthanc::Orthanc$post_patients_id_reconstruct()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_peers_id_store"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_peers_id_store'><code>orthanc::Orthanc$post_peers_id_store()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_peers_id_store_straight"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_peers_id_store_straight'><code>orthanc::Orthanc$post_peers_id_store_straight()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_queries_id_answers_index_query_instances"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_queries_id_answers_index_query_instances'><code>orthanc::Orthanc$post_queries_id_answers_index_query_instances()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_queries_id_answers_index_query_series"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_queries_id_answers_index_query_series'><code>orthanc::Orthanc$post_queries_id_answers_index_query_series()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_queries_id_answers_index_query_studies"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_queries_id_answers_index_query_studies'><code>orthanc::Orthanc$post_queries_id_answers_index_query_studies()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_queries_id_answers_index_retrieve"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_queries_id_answers_index_retrieve'><code>orthanc::Orthanc$post_queries_id_answers_index_retrieve()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_queries_id_retrieve"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_queries_id_retrieve'><code>orthanc::Orthanc$post_queries_id_retrieve()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_anonymize"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_anonymize'><code>orthanc::Orthanc$post_series_id_anonymize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_archive'><code>orthanc::Orthanc$post_series_id_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_attachments_name_compress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_attachments_name_compress'><code>orthanc::Orthanc$post_series_id_attachments_name_compress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_attachments_name_uncompress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_attachments_name_uncompress'><code>orthanc::Orthanc$post_series_id_attachments_name_uncompress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_attachments_name_verify_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_attachments_name_verify_md5'><code>orthanc::Orthanc$post_series_id_attachments_name_verify_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_media'><code>orthanc::Orthanc$post_series_id_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_modify"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_modify'><code>orthanc::Orthanc$post_series_id_modify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_series_id_reconstruct"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_series_id_reconstruct'><code>orthanc::Orthanc$post_series_id_reconstruct()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_storage_commitment_id_remove"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_storage_commitment_id_remove'><code>orthanc::Orthanc$post_storage_commitment_id_remove()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_anonymize"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_anonymize'><code>orthanc::Orthanc$post_studies_id_anonymize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_archive'><code>orthanc::Orthanc$post_studies_id_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_attachments_name_compress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_attachments_name_compress'><code>orthanc::Orthanc$post_studies_id_attachments_name_compress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_attachments_name_uncompress"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_attachments_name_uncompress'><code>orthanc::Orthanc$post_studies_id_attachments_name_uncompress()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_attachments_name_verify_md5"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_attachments_name_verify_md5'><code>orthanc::Orthanc$post_studies_id_attachments_name_verify_md5()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_media'><code>orthanc::Orthanc$post_studies_id_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_merge"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_merge'><code>orthanc::Orthanc$post_studies_id_merge()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_modify"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_modify'><code>orthanc::Orthanc$post_studies_id_modify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_reconstruct"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_reconstruct'><code>orthanc::Orthanc$post_studies_id_reconstruct()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_studies_id_split"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_studies_id_split'><code>orthanc::Orthanc$post_studies_id_split()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_bulk_anonymize"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_bulk_anonymize'><code>orthanc::Orthanc$post_tools_bulk_anonymize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_bulk_content"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_bulk_content'><code>orthanc::Orthanc$post_tools_bulk_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_bulk_delete"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_bulk_delete'><code>orthanc::Orthanc$post_tools_bulk_delete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_bulk_modify"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_bulk_modify'><code>orthanc::Orthanc$post_tools_bulk_modify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_count_resources"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_count_resources'><code>orthanc::Orthanc$post_tools_count_resources()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_create_archive"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_create_archive'><code>orthanc::Orthanc$post_tools_create_archive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_create_dicom"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_create_dicom'><code>orthanc::Orthanc$post_tools_create_dicom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_create_media"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_create_media'><code>orthanc::Orthanc$post_tools_create_media()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_create_media_extended"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_create_media_extended'><code>orthanc::Orthanc$post_tools_create_media_extended()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_dicom_echo"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_dicom_echo'><code>orthanc::Orthanc$post_tools_dicom_echo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_execute_script"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_execute_script'><code>orthanc::Orthanc$post_tools_execute_script()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_find"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_find'><code>orthanc::Orthanc$post_tools_find()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_invalidate_tags"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_invalidate_tags'><code>orthanc::Orthanc$post_tools_invalidate_tags()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_lookup"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_lookup'><code>orthanc::Orthanc$post_tools_lookup()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_reconstruct"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_reconstruct'><code>orthanc::Orthanc$post_tools_reconstruct()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_reset"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_reset'><code>orthanc::Orthanc$post_tools_reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="post_tools_shutdown"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-post_tools_shutdown'><code>orthanc::Orthanc$post_tools_shutdown()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_instances_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_instances_id_attachments_name'><code>orthanc::Orthanc$put_instances_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_instances_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_instances_id_labels_label'><code>orthanc::Orthanc$put_instances_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_instances_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_instances_id_metadata_name'><code>orthanc::Orthanc$put_instances_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_modalities_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_modalities_id'><code>orthanc::Orthanc$put_modalities_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_patients_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_patients_id_attachments_name'><code>orthanc::Orthanc$put_patients_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_patients_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_patients_id_labels_label'><code>orthanc::Orthanc$put_patients_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_patients_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_patients_id_metadata_name'><code>orthanc::Orthanc$put_patients_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_patients_id_protected"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_patients_id_protected'><code>orthanc::Orthanc$put_patients_id_protected()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_peers_id"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_peers_id'><code>orthanc::Orthanc$put_peers_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_series_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_series_id_attachments_name'><code>orthanc::Orthanc$put_series_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_series_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_series_id_labels_label'><code>orthanc::Orthanc$put_series_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_series_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_series_id_metadata_name'><code>orthanc::Orthanc$put_series_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_studies_id_attachments_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_studies_id_attachments_name'><code>orthanc::Orthanc$put_studies_id_attachments_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_studies_id_labels_label"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_studies_id_labels_label'><code>orthanc::Orthanc$put_studies_id_labels_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_studies_id_metadata_name"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_studies_id_metadata_name'><code>orthanc::Orthanc$put_studies_id_metadata_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_accepted_transfer_syntaxes"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_accepted_transfer_syntaxes'><code>orthanc::Orthanc$put_tools_accepted_transfer_syntaxes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_default_encoding"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_default_encoding'><code>orthanc::Orthanc$put_tools_default_encoding()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level'><code>orthanc::Orthanc$put_tools_log_level()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_dicom"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_dicom'><code>orthanc::Orthanc$put_tools_log_level_dicom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_generic"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_generic'><code>orthanc::Orthanc$put_tools_log_level_generic()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_http"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_http'><code>orthanc::Orthanc$put_tools_log_level_http()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_jobs"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_jobs'><code>orthanc::Orthanc$put_tools_log_level_jobs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_lua"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_lua'><code>orthanc::Orthanc$put_tools_log_level_lua()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_plugins"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_plugins'><code>orthanc::Orthanc$put_tools_log_level_plugins()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_log_level_sqlite"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_log_level_sqlite'><code>orthanc::Orthanc$put_tools_log_level_sqlite()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_metrics"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_metrics'><code>orthanc::Orthanc$put_tools_metrics()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="put_tools_unknown_sop_class_accepted"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-put_tools_unknown_sop_class_accepted'><code>orthanc::Orthanc$put_tools_unknown_sop_class_accepted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Orthanc" data-id="stream"><a href='../../orthanc/html/Orthanc.html#method-Orthanc-stream'><code>orthanc::Orthanc$stream()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OrthancAsync-print"></a>}}
\if{latex}{\out{\hypertarget{method-OrthancAsync-print}{}}}
\subsection{Method \code{print()}}{
Print method for \code{Orthanc}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OrthancAsync$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Object to print.}

\item{\code{...}}{Further arguments passed to or from other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OrthancAsync-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OrthancAsync-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OrthancAsync$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
