% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Patient.R
\name{Patient}
\alias{Patient}
\title{DICOM Patient Class}
\value{
An R6 instance of class \code{"Patient"}.
}
\description{
An abstract class for a DICOM Patient resource.
}
\section{Super class}{
\code{\link[orthanc:Resource]{orthanc::Resource}} -> \code{Patient}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{patient_id}}{Patient ID}

\item{\code{name}}{Patient Name}

\item{\code{birth_date}}{Patient Birth Date}

\item{\code{sex}}{Patient Sex}

\item{\code{other_patient_ids}}{Other Patient IDs}

\item{\code{is_stable}}{Is stable?}

\item{\code{last_update}}{Last Update}

\item{\code{labels}}{Labels}

\item{\code{protected}}{Get or set if patient is protected against recycling}

\item{\code{studies_ids}}{Studies identifiers}

\item{\code{series_ids}}{Series identifiers}

\item{\code{instances_ids}}{Instances identifiers}

\item{\code{studies}}{Studies}

\item{\code{series}}{Series}

\item{\code{instances}}{Instances}

\item{\code{instances_tags}}{Instances tags}

\item{\code{shared_tags}}{Shared tags}

\item{\code{statistics}}{Statistics}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Patient-get_main_information}{\code{Patient$get_main_information()}}
\item \href{#method-Patient-add_label}{\code{Patient$add_label()}}
\item \href{#method-Patient-remove_label}{\code{Patient$remove_label()}}
\item \href{#method-Patient-get_zip}{\code{Patient$get_zip()}}
\item \href{#method-Patient-download}{\code{Patient$download()}}
\item \href{#method-Patient-get_patient_module}{\code{Patient$get_patient_module()}}
\item \href{#method-Patient-anonymize}{\code{Patient$anonymize()}}
\item \href{#method-Patient-anonymize_as_job}{\code{Patient$anonymize_as_job()}}
\item \href{#method-Patient-modify}{\code{Patient$modify()}}
\item \href{#method-Patient-modify_as_job}{\code{Patient$modify_as_job()}}
\item \href{#method-Patient-get_shared_tags}{\code{Patient$get_shared_tags()}}
\item \href{#method-Patient-remove_empty_studies}{\code{Patient$remove_empty_studies()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Resource" data-id="initialize"><a href='../../orthanc/html/Resource.html#method-Resource-initialize'><code>orthanc::Resource$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Resource" data-id="print"><a href='../../orthanc/html/Resource.html#method-Resource-print'><code>orthanc::Resource$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="orthanc" data-topic="Resource" data-id="set_child_resources"><a href='../../orthanc/html/Resource.html#method-Resource-set_child_resources'><code>orthanc::Resource$set_child_resources()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-get_main_information"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-get_main_information}{}}}
\subsection{Method \code{get_main_information()}}{
Get patient information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$get_main_information()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-add_label"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-add_label}{}}}
\subsection{Method \code{add_label()}}{
Add label to resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$add_label(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Label.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-remove_label"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-remove_label}{}}}
\subsection{Method \code{remove_label()}}{
Delete label from resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$remove_label(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Label.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-get_zip"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-get_zip}{}}}
\subsection{Method \code{get_zip()}}{
Get the bytes of the zip file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$get_zip()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-download"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-download}{}}}
\subsection{Method \code{download()}}{
Download the zip file to a path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$download(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File path on disk.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-get_patient_module"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-get_patient_module}{}}}
\subsection{Method \code{get_patient_module()}}{
Get patient module in a simplified version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$get_patient_module()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-anonymize"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-anonymize}{}}}
\subsection{Method \code{anonymize()}}{
Anonymize Patient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$anonymize(
  remove = list(),
  replace = list(),
  keep = list(),
  keep_private_tags = FALSE,
  keep_source = TRUE,
  priority = 0L,
  permissive = FALSE,
  private_creator = NULL,
  force = FALSE,
  dicom_version = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove}}{List of tags to remove.}

\item{\code{replace}}{Named-list of tags to replce.}

\item{\code{keep}}{List of tags to keep unchanged.}

\item{\code{keep_private_tags}}{Keep private tags from DICOM instance.}

\item{\code{keep_source}}{Keep original resource.}

\item{\code{priority}}{Priority of the job.}

\item{\code{permissive}}{Ignore errors during individual steps of the job?}

\item{\code{private_creator}}{Private creator to be used for private tags in
replace.}

\item{\code{force}}{Force tags to be changed.}

\item{\code{dicom_version}}{Version of the DICOM standard to use for
anonymization.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-anonymize_as_job"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-anonymize_as_job}{}}}
\subsection{Method \code{anonymize_as_job()}}{
Anonymize Patient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$anonymize_as_job(
  remove = list(),
  replace = list(),
  keep = list(),
  keep_private_tags = FALSE,
  keep_source = TRUE,
  priority = 0L,
  permissive = FALSE,
  private_creator = NULL,
  force = FALSE,
  dicom_version = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove}}{List of tags to remove.}

\item{\code{replace}}{Named-list of tags to replce.}

\item{\code{keep}}{List of tags to keep unchanged.}

\item{\code{keep_private_tags}}{Keep private tags from DICOM instance.}

\item{\code{keep_source}}{Keep original resource.}

\item{\code{priority}}{Priority of the job.}

\item{\code{permissive}}{Ignore errors during individual steps of the job?}

\item{\code{private_creator}}{Private creator to be used for private tags in
replace.}

\item{\code{force}}{Force tags to be changed.}

\item{\code{dicom_version}}{Version of the DICOM standard to use for
anonymization.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-modify"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-modify}{}}}
\subsection{Method \code{modify()}}{
Modify Patient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$modify(
  remove = list(),
  replace = list(),
  keep = list(),
  remove_private_tags = FALSE,
  keep_source = TRUE,
  priority = 0L,
  permissive = FALSE,
  private_creator = NULL,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove}}{List of tags to remove.}

\item{\code{replace}}{Named-list of tags to replce.}

\item{\code{keep}}{List of tags to keep unchanged.}

\item{\code{remove_private_tags}}{Remove private tags from DICOM instance.}

\item{\code{keep_source}}{Keep original resource.}

\item{\code{priority}}{Priority of the job.}

\item{\code{permissive}}{Ignore errors during individual steps of the job?}

\item{\code{private_creator}}{Private creator to be used for private tags in
replace.}

\item{\code{force}}{Force tags to be changed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-modify_as_job"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-modify_as_job}{}}}
\subsection{Method \code{modify_as_job()}}{
Modify Patient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$modify_as_job(
  remove = list(),
  replace = list(),
  keep = list(),
  remove_private_tags = FALSE,
  keep_source = TRUE,
  priority = 0L,
  permissive = FALSE,
  private_creator = NULL,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove}}{List of tags to remove.}

\item{\code{replace}}{Named-list of tags to replce.}

\item{\code{keep}}{List of tags to keep unchanged.}

\item{\code{remove_private_tags}}{Remove private tags from DICOM instance.}

\item{\code{keep_source}}{Keep original resource.}

\item{\code{priority}}{Priority of the job.}

\item{\code{permissive}}{Ignore errors during individual steps of the job?}

\item{\code{private_creator}}{Private creator to be used for private tags in
replace.}

\item{\code{force}}{Force tags to be changed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-get_shared_tags"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-get_shared_tags}{}}}
\subsection{Method \code{get_shared_tags()}}{
Retrieve the shared tags of the patient.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$get_shared_tags()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Patient-remove_empty_studies"></a>}}
\if{latex}{\out{\hypertarget{method-Patient-remove_empty_studies}{}}}
\subsection{Method \code{remove_empty_studies()}}{
Remove empty studies from patient.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Patient$remove_empty_studies()}\if{html}{\out{</div>}}
}

}
}
