% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{query_orthanc}
\alias{query_orthanc}
\title{Query data in the Orthanc server}
\usage{
query_orthanc(
  client,
  level,
  query = list(),
  labels = character(),
  labels_constraint = "All",
  limit = 1000L,
  since = 0L,
  retrieve_all_resources = TRUE,
  lock_children = FALSE
)
}
\arguments{
\item{client}{Orthanc API client.}

\item{level}{Level of the query ('Patient', 'Study', 'Series', 'Instance').}

\item{query}{Named-list that specifies the filters on the level related DICOM
tags.}

\item{labels}{Character vector of labels to look for in resources.}

\item{labels_constraint}{Contraint on the labels ('All', 'Any', 'None').}

\item{limit}{Limit the number of reported instances (default is \code{1000L}).}

\item{since}{Show only the resources since the index specified in the \code{since}
parameter.}

\item{retrieve_all_resources}{Retrieve all resources since the index
specified in the \code{since} parameter.}

\item{lock_children}{If \code{lock_children} is \code{TRUE}, the resource children
(e.g., instances of a series via \code{Series.instances}) will be cached at the
first query rather than queried every time. This is useful when you want
to filter the children of a resource and want to maintain the filter
result.}
}
\value{
A \code{list} of resources.
}
\description{
Query data in the Orthanc server
}
\examples{
client <- Orthanc$new("https://orthanc.uclouvain.be/demo")
query_orthanc(client, "Patient", list(PatientName = "HN_P001"))
}
