% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_.R
\name{strategy_maic}
\alias{strategy_maic}
\alias{strategy_stc}
\alias{strategy_gcomp_ml}
\alias{strategy_gcomp_bayes}
\alias{strategy_mim}
\alias{strategy}
\alias{new_strategy}
\title{New strategy objects}
\usage{
strategy_maic(
  formula = NULL,
  family = gaussian(link = "identity"),
  trt_var = NULL,
  n_boot = 1000L
)

strategy_stc(
  formula = NULL,
  family = gaussian(link = "identity"),
  trt_var = NULL
)

strategy_gcomp_ml(
  formula = NULL,
  family = gaussian(link = "identity"),
  trt_var = NULL,
  rho = NA,
  marginal_distns = NA,
  marginal_params = NA,
  n_boot = 1000L,
  N = 1000L
)

strategy_gcomp_bayes(
  formula = NULL,
  family = gaussian(link = "identity"),
  trt_var = NULL,
  rho = NA,
  marginal_distns = NA,
  marginal_params = NA,
  N = 1000L
)

strategy_mim(
  formula = NULL,
  family = gaussian(link = "identity"),
  trt_var = NULL,
  rho = NA,
  N = 1000L
)

new_strategy(strategy, ...)
}
\arguments{
\item{formula}{Linear regression \code{formula} object. Prognostic factors (PF) are main effects and effect modifiers (EM) are
interactions with the treatment variable, e.g., y ~ X1 + trt + trt:X2. For covariates as both PF and EM use \code{*} syntax.}

\item{family}{A 'family' object specifying the distribution and link function (e.g., 'binomial').
See stats::family() for more details.}

\item{trt_var}{Treatment variable name; string}

\item{n_boot}{The number of resamples used for the non-parametric bootstrap; integer}

\item{rho}{A named square matrix of covariate correlations; default NA}

\item{marginal_distns}{Marginal distributions names; vector default NA.
Available distributions are given in stats::Distributions. See \code{\link[copula:Mvdc]{copula::Mvdc()}} for details}

\item{marginal_params}{Marginal distributions parameters; list of lists, default NA. See \code{\link[copula:Mvdc]{copula::Mvdc()}} for details}

\item{N}{Synthetic sample size for g-computation}

\item{strategy}{Class name from \code{strategy_maic}, \code{strategy_stc}, \code{strategy_gcomp_ml}, \code{strategy_gcomp_bayes}, \code{strategy_mim}}

\item{...}{Additional arguments}
}
\value{
\code{maic} class object

\code{stc} class object

\code{gcomp_ml} class object

\code{gcomp_bayes} class object

\code{mim} class object

Strategy list object
}
\description{
Create a type of strategy class for each modelling approach.
}
\note{
While current implementations focus on binary, continuous, and count outcomes,
support for survival data (using the \code{survival} package) is under active
development and scheduled for version 1.1.0.
}
\section{Matching-adjusted indirect comparison (MAIC)}{

MAIC is a form of non-parametric likelihood reweighting method
which allows the propensity score logistic
regression model to be estimated without IPD in the \emph{AC} population.
The mean outcomes \eqn{\mu_{t(AC)}} on treatment \eqn{t = A,B} in the \emph{AC}
target population are estimated by taking a weighted average of the
outcomes \eqn{Y} of the \eqn{N} individuals in arm \eqn{t} of the \emph{AB} population.

Used to compare marginal treatment effects where there are cross-trial
differences in effect modifiers and limited patient-level data.

\deqn{
\hat{Y}_{} = \frac{\sum_{i=1}^{N} Y_{it(AB)} w_{it}}{\sum_{i=1}^{N} w_{it}}
}
where the weight \eqn{w_{it}} assigned to the \eqn{i}-th individual receiving treatment
\eqn{t} is equal to the odds of being enrolled in the \emph{AC} trial vs the \emph{AB} trial.
}

\section{Simulated treatment comparison (STC)}{

Outcome regression-based method which targets a conditional treatment effect.
STC is a modification of the covariate adjustment method.
An outcome model is fitted using IPD in the \emph{AB} trial. For example,

\deqn{
g(\mu_{t(AB)}(X)) = \beta_0 + \beta_1^T X + (\beta_B + \beta_2^T X^{EM}) I(t=B)
}
where \eqn{\beta_0} is an intercept term, \eqn{\beta_1} is a vector of coefficients for
prognostic variables, \eqn{\beta_B} is the relative effect of treatment \emph{B} compared
to \emph{A} at \eqn{X=0}, \eqn{\beta_2} is a vector of coefficients for effect
modifiers \eqn{X^{EM}} subvector of the full covariate vector \eqn{X}), and
\eqn{\mu_{t(AB)}(X)} is the expected outcome of an individual assigned
treatment \eqn{t} with covariate values \eqn{X} which is transformed onto a
chosen linear predictor scale with link function \eqn{g(\cdot)}.
}

\section{G-computation maximum likelihood}{

G-computation marginalizes the conditional estimates by separating the regression modelling
from the estimation of the marginal treatment effect for \emph{A} versus \emph{C}.
For example, a regression model of the observed outcome \eqn{y} on the covariates \eqn{x} and
treatment \eqn{z} is fitted to the \emph{AC} IPD:

\deqn{
g(\mu_n) = \beta_0 + \boldsymbol{x}_n \boldsymbol{\beta_1} + (\beta_z + \boldsymbol{x_n^{EM}} \boldsymbol{\beta_2}) \mbox{I}(z_n=1)
}
In the context of G-computation, this regression model is called the “Q-model".
Having fitted the Q-model, the regression coefficients are treated as nuisance parameters.
The parameters are applied to the simulated covariates \eqn{x*} to predict hypothetical outcomes
for each subject under both possible treatments. Namely, a pair of predicted outcomes,
also called potential outcomes, under \emph{A} and under \emph{C}, is generated for each subject.

By plugging treatment \emph{C} into the regression fit for every simulated observation,
we predict the marginal outcome mean in the hypothetical scenario in which all units are under treatment \emph{C}:

\deqn{
\hat{\mu}_0 = \int_{x^*} g^{-1} (\hat{\beta}_0 + x^* \hat{\beta}_1 ) p(x^*) dx^*
}
To estimate the marginal or population-average treatment effect for \emph{A} versus \emph{C} in the linear predictor scale,
one back-transforms to this scale the average predictions, taken over all subjects on the natural outcome scale,
and calculates the difference between the average linear predictions:

\deqn{
\hat{\Delta}^{(2)}_{10} = g(\hat{\mu}_1) - g(\hat{\mu}_0)
}
}

\section{G-computation Bayesian}{

The difference between Bayesian G-computation and its maximum-likelihood
counterpart is in the estimated distribution of the predicted outcomes. The
Bayesian approach also marginalizes, integrates or standardizes over the
joint posterior distribution of the conditional nuisance parameters of the
outcome regression, as well as the joint covariate distribution.

Draw a vector of size \eqn{N*} of predicted outcomes \eqn{y*z} under each set
intervention \eqn{z* \in \{0, 1\}} from its posterior predictive distribution
under the specific treatment. This is defined as \eqn{p(y*_{z*} |
\mathcal{D}_{AC}) = \int_{\beta} p(y*_{z*} | \beta) p(\beta | \mathcal{D}_{AC}) d\beta}
where \eqn{p(\beta | \mathcal{D}_{AC})} is the
posterior distribution of the outcome regression coefficients \eqn{\beta},
which encode the predictor-outcome relationships observed in the \emph{AC} trial IPD.

This is given by:

\deqn{
p(y*_{z*} \mid \mathcal{D}_{AC}) = \int_{x*} p(y* \mid z*, x*, \mathcal{D}_{AC}) p(x* \mid \mathcal{D}_{AC}) dx*
}

\deqn{
= \int_{x*} \int_{\beta} p(y* \mid z*, x*, \beta) p(x* \mid \beta) p(\beta \mid \mathcal{D}_{AC}) d\beta dx*
}
In practice, the integrals above can be approximated numerically, using full Bayesian
estimation via Markov chain Monte Carlo (MCMC) sampling.
}

\section{Multiple imputation marginalization (MIM)}{

TODO
}

\seealso{
\code{\link[=strategy_gcomp_bayes]{strategy_gcomp_bayes()}}

\code{\link[=strategy_gcomp_ml]{strategy_gcomp_ml()}},\code{\link[copula:Mvdc]{copula::Mvdc()}}
}
