% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-pv.R
\name{retrieve_linked_data}
\alias{retrieve_linked_data}
\title{Retrieve Linked Data}
\usage{
retrieve_linked_data(url, api_key = Sys.getenv("PATENTSVIEW_API_KEY"), ...)
}
\arguments{
\item{url}{A link that was returned by the API on a previous call.}

\item{api_key}{API key, it defaults to Sys.getenv("PATENTSVIEW_API_KEY"). Request a key
\href{https://patentsview-support.atlassian.net/servicedesk/customer/portals}{here}.}

\item{...}{Curl options passed along to httr2's \code{\link[httr2]{req_options}}
when we do GETs or POSTs.}
}
\description{
Some of the endpoints now return HATEOAS style links to get more data. E.g.,
the patent endpoint may return a link such as:
"https://search.patentsview.org/api/v1/inventor/fl:th_ln:jefferson-1/". Use
this function to fetch details from those links.
}
\examples{
\dontrun{

retrieve_linked_data(
  "https://search.patentsview.org/api/v1/cpc_group/G01S7:4811/"
)
}

}
