% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_create_stack_set}
\alias{cloudformation_create_stack_set}
\title{Creates a stack set}
\usage{
cloudformation_create_stack_set(
  StackSetName,
  Description = NULL,
  TemplateBody = NULL,
  TemplateURL = NULL,
  StackId = NULL,
  Parameters = NULL,
  Capabilities = NULL,
  Tags = NULL,
  AdministrationRoleARN = NULL,
  ExecutionRoleName = NULL,
  PermissionModel = NULL,
  AutoDeployment = NULL,
  CallAs = NULL,
  ClientRequestToken = NULL,
  ManagedExecution = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name to associate with the stack set. The name must be unique in the
Region where you create your stack set.

A stack name can contain only alphanumeric characters (case-sensitive)
and hyphens. It must start with an alphabetic character and can't be
longer than 128 characters.}

\item{Description}{A description of the stack set. You can use the description to identify
the stack set's purpose or other important information.}

\item{TemplateBody}{The structure that contains the template body, with a minimum length of
1 byte and a maximum length of 51,200 bytes.

Conditional: You must specify either the TemplateBody or the TemplateURL
parameter, but not both.}

\item{TemplateURL}{The URL of a file that contains the template body. The URL must point to
a template (maximum size: 1 MB) that's located in an Amazon S3 bucket or
a Systems Manager document. The location for an Amazon S3 bucket must
start with \verb{https://}.

Conditional: You must specify either the TemplateBody or the TemplateURL
parameter, but not both.}

\item{StackId}{The stack ID you are importing into a new stack set. Specify the Amazon
Resource Name (ARN) of the stack.}

\item{Parameters}{The input parameters for the stack set template.}

\item{Capabilities}{In some cases, you must explicitly acknowledge that your stack set
template contains certain capabilities in order for CloudFormation to
create the stack set and related stack instances.
\itemize{
\item \code{CAPABILITY_IAM} and \code{CAPABILITY_NAMED_IAM}

Some stack templates might include resources that can affect
permissions in your Amazon Web Services account; for example, by
creating new IAM users. For those stack sets, you must explicitly
acknowledge this by specifying one of these capabilities.

The following IAM resources require you to specify either the
\code{CAPABILITY_IAM} or \code{CAPABILITY_NAMED_IAM} capability.
\itemize{
\item If you have IAM resources, you can specify either capability.
\item If you have IAM resources with custom names, you \emph{must} specify
\code{CAPABILITY_NAMED_IAM}.
\item If you don't specify either of these capabilities,
CloudFormation returns an \code{InsufficientCapabilities} error.
}

If your stack template contains these resources, we recommend that
you review all permissions associated with them and edit their
permissions if necessary.
\itemize{
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html}{AWS::IAM::AccessKey}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html}{AWS::IAM::Group}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html}{AWS::IAM::Policy}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html}{AWS::IAM::User}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html}{AWS::IAM::UserToGroupAddition}
}

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities}{Acknowledging IAM resources in CloudFormation templates}.
\item \code{CAPABILITY_AUTO_EXPAND}

Some templates reference macros. If your stack set template
references one or more macros, you must create the stack set
directly from the processed template, without first reviewing the
resulting changes in a change set. To create the stack set directly,
you must acknowledge this capability. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html}{Perform custom processing on CloudFormation templates with template macros}.

Stack sets with service-managed permissions don't currently support
the use of macros in templates. (This includes the
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-include.html}{AWS::Include}
and
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html}{AWS::Serverless}
transforms, which are macros hosted by CloudFormation.) Even if you
specify this capability for a stack set with service-managed
permissions, if you reference a macro in your template the stack set
operation will fail.
}}

\item{Tags}{The key-value pairs to associate with this stack set and the stacks
created from it. CloudFormation also propagates these tags to supported
resources that are created in the stacks. A maximum number of 50 tags
can be specified.

If you specify tags as part of a
\code{\link[=cloudformation_create_stack_set]{create_stack_set}} action,
CloudFormation checks to see if you have the required IAM permission to
tag resources. If you don't, the entire
\code{\link[=cloudformation_create_stack_set]{create_stack_set}} action fails with
an \verb{access denied} error, and the stack set is not created.}

\item{AdministrationRoleARN}{The Amazon Resource Name (ARN) of the IAM role to use to create this
stack set.

Specify an IAM role only if you are using customized administrator roles
to control which users or groups can manage specific stack sets within
the same administrator account. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html}{Prerequisites for using StackSets}
in the \emph{CloudFormation User Guide}.}

\item{ExecutionRoleName}{The name of the IAM execution role to use to create the stack set. If
you do not specify an execution role, CloudFormation uses the
\code{AWSCloudFormationStackSetExecutionRole} role for the stack set
operation.

Specify an IAM role only if you are using customized execution roles to
control which stack resources users and groups can include in their
stack sets.}

\item{PermissionModel}{Describes how the IAM roles required for stack set operations are
created. By default, \code{SELF-MANAGED} is specified.
\itemize{
\item With \code{self-managed} permissions, you must create the administrator
and execution roles required to deploy to target accounts. For more
information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html}{Grant self-managed permissions}.
\item With \code{service-managed} permissions, StackSets automatically creates
the IAM roles required to deploy to accounts managed by
Organizations. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html}{Activate trusted access for stack sets with Organizations}.
}}

\item{AutoDeployment}{Describes whether StackSets automatically deploys to Organizations
accounts that are added to the target organization or organizational
unit (OU). Specify only if \code{PermissionModel} is \code{SERVICE_MANAGED}.}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item To create a stack set with service-managed permissions while signed
in to the management account, specify \code{SELF}.
\item To create a stack set with service-managed permissions while signed
in to a delegated administrator account, specify \code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
admin in the management account. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}

Stack sets with service-managed permissions are created in the
management account, including stack sets that are created by delegated
administrators.}

\item{ClientRequestToken}{A unique identifier for this
\code{\link[=cloudformation_create_stack_set]{create_stack_set}} request. Specify
this token if you plan to retry requests so that CloudFormation knows
that you're not attempting to create another stack set with the same
name. You might retry
\code{\link[=cloudformation_create_stack_set]{create_stack_set}} requests to ensure
that CloudFormation successfully received them.

If you don't specify an operation ID, the SDK generates one
automatically.}

\item{ManagedExecution}{Describes whether StackSets performs non-conflicting operations
concurrently and queues conflicting operations.}
}
\description{
Creates a stack set.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_create_stack_set/} for full documentation.
}
\keyword{internal}
