% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_hook_results}
\alias{cloudformation_list_hook_results}
\title{Returns summaries of invoked Hooks when a change set or Cloud Control
API operation target is provided}
\usage{
cloudformation_list_hook_results(TargetType, TargetId, NextToken = NULL)
}
\arguments{
\item{TargetType}{[required] The type of operation being targeted by the Hook.}

\item{TargetId}{[required] The logical ID of the target the operation is acting on by the Hook. If
the target is a change set, it's the ARN of the change set.

If the target is a Cloud Control API operation, this will be the
\code{HookRequestToken} returned by the Cloud Control API operation request.
For more information on the \code{HookRequestToken}, see
\href{https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html}{ProgressEvent}.}

\item{NextToken}{A string that identifies the next page of events that you want to
retrieve.}
}
\description{
Returns summaries of invoked Hooks when a change set or Cloud Control API operation target is provided.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_list_hook_results/} for full documentation.
}
\keyword{internal}
