% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_update_stack_instances}
\alias{cloudformation_update_stack_instances}
\title{Updates the parameter values for stack instances for the specified
accounts, within the specified Amazon Web Services Regions}
\usage{
cloudformation_update_stack_instances(
  StackSetName,
  Accounts = NULL,
  DeploymentTargets = NULL,
  Regions,
  ParameterOverrides = NULL,
  OperationPreferences = NULL,
  OperationId = NULL,
  CallAs = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set associated with the stack
instances.}

\item{Accounts}{[Self-managed permissions] The account IDs of one or more Amazon Web
Services accounts for which you want to update parameter values for
stack instances. The overridden parameter values will be applied to all
stack instances in the specified accounts and Amazon Web Services
Regions.

You can specify \code{Accounts} or \code{DeploymentTargets}, but not both.}

\item{DeploymentTargets}{[Service-managed permissions] The Organizations accounts for which you
want to update parameter values for stack instances. If your update
targets OUs, the overridden parameter values only apply to the accounts
that are currently in the target OUs and their child OUs. Accounts added
to the target OUs and their child OUs in the future won't use the
overridden values.

You can specify \code{Accounts} or \code{DeploymentTargets}, but not both.}

\item{Regions}{[required] The names of one or more Amazon Web Services Regions in which you want
to update parameter values for stack instances. The overridden parameter
values will be applied to all stack instances in the specified accounts
and Amazon Web Services Regions.}

\item{ParameterOverrides}{A list of input parameters whose values you want to update for the
specified stack instances.

Any overridden parameter values will be applied to all stack instances
in the specified accounts and Amazon Web Services Regions. When
specifying parameters and their values, be aware of how CloudFormation
sets parameter values during stack instance update operations:
\itemize{
\item To override the current value for a parameter, include the parameter
and specify its value.
\item To leave an overridden parameter set to its present value, include
the parameter and specify \code{UsePreviousValue} as \code{true}. (You can't
specify both a value and set \code{UsePreviousValue} to \code{true}.)
\item To set an overridden parameter back to the value specified in the
stack set, specify a parameter list but don't include the parameter
in the list.
\item To leave all parameters set to their present values, don't specify
this property at all.
}

During stack set updates, any parameter values overridden for a stack
instance aren't updated, but retain their overridden value.

You can only override the parameter \emph{values} that are specified in the
stack set; to add or delete a parameter itself, use
\code{\link[=cloudformation_update_stack_set]{update_stack_set}} to update the
stack set template. If you add a parameter to a template, before you can
override the parameter value specified in the stack set you must first
use \code{\link[=cloudformation_update_stack_set]{update_stack_set}} to update all
stack instances with the updated template and parameter value specified
in the stack set. Once a stack instance has been updated with the new
parameter, you can then override the parameter value using
\code{\link[=cloudformation_update_stack_instances]{update_stack_instances}}.}

\item{OperationPreferences}{Preferences for how CloudFormation performs this stack set operation.}

\item{OperationId}{The unique identifier for this stack set operation.

The operation ID also functions as an idempotency token, to ensure that
CloudFormation performs the stack set operation only once, even if you
retry the request multiple times. You might retry stack set operation
requests to ensure that CloudFormation successfully received them.

If you don't specify an operation ID, the SDK generates one
automatically.}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}
}
\description{
Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_update_stack_instances/} for full documentation.
}
\keyword{internal}
