% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_get_insight_rule_report}
\alias{cloudwatch_get_insight_rule_report}
\title{This operation returns the time series data collected by a Contributor
Insights rule}
\usage{
cloudwatch_get_insight_rule_report(
  RuleName,
  StartTime,
  EndTime,
  Period,
  MaxContributorCount = NULL,
  Metrics = NULL,
  OrderBy = NULL
)
}
\arguments{
\item{RuleName}{[required] The name of the rule that you want to see data from.}

\item{StartTime}{[required] The start time of the data to use in the report. When used in a raw HTTP
Query API, it is formatted as \verb{yyyy-MM-dd'T'HH:mm:ss}. For example,
\verb{2019-07-01T23:59:59}.}

\item{EndTime}{[required] The end time of the data to use in the report. When used in a raw HTTP
Query API, it is formatted as \verb{yyyy-MM-dd'T'HH:mm:ss}. For example,
\verb{2019-07-01T23:59:59}.}

\item{Period}{[required] The period, in seconds, to use for the statistics in the
\code{InsightRuleMetricDatapoint} results.}

\item{MaxContributorCount}{The maximum number of contributors to include in the report. The range
is 1 to 100. If you omit this, the default of 10 is used.}

\item{Metrics}{Specifies which metrics to use for aggregation of contributor values for
the report. You can specify one or more of the following metrics:
\itemize{
\item \code{UniqueContributors} -- the number of unique contributors for each
data point.
\item \code{MaxContributorValue} -- the value of the top contributor for each
data point. The identity of the contributor might change for each
data point in the graph.

If this rule aggregates by COUNT, the top contributor for each data
point is the contributor with the most occurrences in that period.
If the rule aggregates by SUM, the top contributor is the
contributor with the highest sum in the log field specified by the
rule's \code{Value}, during that period.
\item \code{SampleCount} -- the number of data points matched by the rule.
\item \code{Sum} -- the sum of the values from all contributors during the time
period represented by that data point.
\item \code{Minimum} -- the minimum value from a single observation during the
time period represented by that data point.
\item \code{Maximum} -- the maximum value from a single observation during the
time period represented by that data point.
\item \code{Average} -- the average value from all contributors during the time
period represented by that data point.
}}

\item{OrderBy}{Determines what statistic to use to rank the contributors. Valid values
are \code{Sum} and \code{Maximum}.}
}
\description{
This operation returns the time series data collected by a Contributor Insights rule. The data includes the identity and number of contributors to the log group.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_get_insight_rule_report/} for full documentation.
}
\keyword{internal}
