% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_metric_filter}
\alias{cloudwatchlogs_put_metric_filter}
\title{Creates or updates a metric filter and associates it with the specified
log group}
\usage{
cloudwatchlogs_put_metric_filter(
  logGroupName,
  filterName,
  filterPattern,
  metricTransformations,
  applyOnTransformedLogs = NULL
)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{filterName}{[required] A name for the metric filter.}

\item{filterPattern}{[required] A filter pattern for extracting metric data out of ingested log events.}

\item{metricTransformations}{[required] A collection of information that defines how metric data gets emitted.}

\item{applyOnTransformedLogs}{This parameter is valid only for log groups that have an active log
transformer. For more information about log transformers, see
\code{\link[=cloudwatchlogs_put_transformer]{put_transformer}}.

If the log group uses either a log-group level or account-level
transformer, and you specify \code{true}, the metric filter will be applied
on the transformed version of the log events instead of the original
ingested log events.}
}
\description{
Creates or updates a metric filter and associates it with the specified log group. With metric filters, you can configure rules to extract metric data from log events ingested through \code{\link[=cloudwatchlogs_put_log_events]{put_log_events}}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_metric_filter/} for full documentation.
}
\keyword{internal}
