% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_create_app_monitor}
\alias{cloudwatchrum_create_app_monitor}
\title{Creates a Amazon CloudWatch RUM app monitor, which collects telemetry
data from your application and sends that data to RUM}
\usage{
cloudwatchrum_create_app_monitor(
  AppMonitorConfiguration = NULL,
  CustomEvents = NULL,
  CwLogEnabled = NULL,
  Domain,
  Name,
  Tags = NULL
)
}
\arguments{
\item{AppMonitorConfiguration}{A structure that contains much of the configuration data for the app
monitor. If you are using Amazon Cognito for authorization, you must
include this structure in your request, and it must include the ID of
the Amazon Cognito identity pool to use for authorization. If you don't
include \code{AppMonitorConfiguration}, you must set up your own
authorization method. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html}{Authorize your application to send data to Amazon Web Services}.

If you omit this argument, the sample rate used for RUM is set to 10\% of
the user sessions.}

\item{CustomEvents}{Specifies whether this app monitor allows the web client to define and
send custom events. If you omit this parameter, custom events are
\code{DISABLED}.

For more information about custom events, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html}{Send custom events}.}

\item{CwLogEnabled}{Data collected by RUM is kept by RUM for 30 days and then deleted. This
parameter specifies whether RUM sends a copy of this telemetry data to
Amazon CloudWatch Logs in your account. This enables you to keep the
telemetry data for more than 30 days, but it does incur Amazon
CloudWatch Logs charges.

If you omit this parameter, the default is \code{false}.}

\item{Domain}{[required] The top-level internet domain name for which your application has
administrative authority.}

\item{Name}{[required] A name for the app monitor.}

\item{Tags}{Assigns one or more tags (key-value pairs) to the app monitor.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

Tags don't have any semantic meaning to Amazon Web Services and are
interpreted strictly as strings of characters.

You can associate as many as 50 tags with an app monitor.

For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}.}
}
\description{
Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchrum_create_app_monitor/} for full documentation.
}
\keyword{internal}
