% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controltower_operations.R
\name{controltower_list_enabled_baselines}
\alias{controltower_list_enabled_baselines}
\title{Returns a list of summaries describing EnabledBaseline resources}
\usage{
controltower_list_enabled_baselines(
  filter = NULL,
  includeChildren = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{filter}{A filter applied on the \code{ListEnabledBaseline} operation. Allowed filters
are \code{baselineIdentifiers} and \code{targetIdentifiers}. The filter can be
applied for either, or both.}

\item{includeChildren}{A value that can be set to include the child enabled baselines in
responses. The default value is false.}

\item{maxResults}{The maximum number of results to be shown.}

\item{nextToken}{A pagination token.}
}
\description{
Returns a list of summaries describing \code{EnabledBaseline} resources. You can filter the list by the corresponding \code{Baseline} or \code{Target} of the \code{EnabledBaseline} resources. For usage examples, see \href{https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html}{\emph{the Amazon Web Services Control Tower User Guide}} .

See \url{https://www.paws-r-sdk.com/docs/controltower_list_enabled_baselines/} for full documentation.
}
\keyword{internal}
