% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioning_artifact}
\alias{servicecatalog_update_provisioning_artifact}
\title{Updates the specified provisioning artifact (also known as a version)
for the specified product}
\usage{
servicecatalog_update_provisioning_artifact(
  AcceptLanguage = NULL,
  ProductId,
  ProvisioningArtifactId,
  Name = NULL,
  Description = NULL,
  Active = NULL,
  Guidance = NULL
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{ProvisioningArtifactId}{[required] The identifier of the provisioning artifact.}

\item{Name}{The updated name of the provisioning artifact.}

\item{Description}{The updated description of the provisioning artifact.}

\item{Active}{Indicates whether the product version is active.

Inactive provisioning artifacts are invisible to end users. End users
cannot launch or update a provisioned product from an inactive
provisioning artifact.}

\item{Guidance}{Information set by the administrator to provide guidance to end users
about which provisioning artifacts to use.

The \code{DEFAULT} value indicates that the product version is active.

The administrator can set the guidance to \code{DEPRECATED} to inform users
that the product version is deprecated. Users are able to make updates
to a provisioned product of a deprecated version but cannot launch new
provisioned products using a deprecated version.}
}
\description{
Updates the specified provisioning artifact (also known as a version) for the specified product.

See \url{https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioning_artifact/} for full documentation.
}
\keyword{internal}
