% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_accept_page}
\alias{ssmcontacts_accept_page}
\title{Used to acknowledge an engagement to a contact channel during an
incident}
\usage{
ssmcontacts_accept_page(
  PageId,
  ContactChannelId = NULL,
  AcceptType,
  Note = NULL,
  AcceptCode,
  AcceptCodeValidation = NULL
)
}
\arguments{
\item{PageId}{[required] The Amazon Resource Name (ARN) of the engagement to a contact channel.}

\item{ContactChannelId}{The ARN of the contact channel.}

\item{AcceptType}{[required] The type indicates if the page was \code{DELIVERED} or \code{READ}.}

\item{Note}{Information provided by the user when the user acknowledges the page.}

\item{AcceptCode}{[required] A 6-digit code used to acknowledge the page.}

\item{AcceptCodeValidation}{An optional field that Incident Manager uses to \code{ENFORCE} \code{AcceptCode}
validation when acknowledging an page. Acknowledgement can occur by
replying to a page, or when entering the AcceptCode in the console.
Enforcing AcceptCode validation causes Incident Manager to verify that
the code entered by the user matches the code sent by Incident Manager
with the page.

Incident Manager can also \code{IGNORE} \code{AcceptCode} validation. Ignoring
\code{AcceptCode} validation causes Incident Manager to accept any value
entered for the \code{AcceptCode}.}
}
\description{
Used to acknowledge an engagement to a contact channel during an incident.

See \url{https://www.paws-r-sdk.com/docs/ssmcontacts_accept_page/} for full documentation.
}
\keyword{internal}
