% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_create_rotation_override}
\alias{ssmcontacts_create_rotation_override}
\title{Creates an override for a rotation in an on-call schedule}
\usage{
ssmcontacts_create_rotation_override(
  RotationId,
  NewContactIds,
  StartTime,
  EndTime,
  IdempotencyToken = NULL
)
}
\arguments{
\item{RotationId}{[required] The Amazon Resource Name (ARN) of the rotation to create an override
for.}

\item{NewContactIds}{[required] The Amazon Resource Names (ARNs) of the contacts to replace those in the
current on-call rotation with.

If you want to include any current team members in the override shift,
you must include their ARNs in the new contact ID list.}

\item{StartTime}{[required] The date and time when the override goes into effect.}

\item{EndTime}{[required] The date and time when the override ends.}

\item{IdempotencyToken}{A token that ensures that the operation is called only once with the
specified details.}
}
\description{
Creates an override for a rotation in an on-call schedule.

See \url{https://www.paws-r-sdk.com/docs/ssmcontacts_create_rotation_override/} for full documentation.
}
\keyword{internal}
