% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_stats.R
\name{isHomozygous}
\alias{isHomozygous}
\title{Find homozygous genotypes}
\usage{
isHomozygous(x, ids = typedMembers(x), count = FALSE)
}
\arguments{
\item{x}{A \code{ped} object or a list of such. An error is raised if \code{x} has no
marker data.}

\item{ids}{A vector of individual ID labels. Defaults to all typed members of
\code{x}.}

\item{count}{A logical. If TRUE, return counts per individual.}
}
\value{
By default, a logical matrix of dimension \verb{N x L}, where N is
\code{length(ids)} and L is the number of markers. If \code{count = TRUE}, a numeric
vector of length N giving the number of homozygous genotypes for each
individual.
}
\description{
Identifies homozygous genotypes in the marker data. A genotype is homozygous
if both alleles are non-missing and equal.
}
\examples{
x = nuclearPed(father = "fa", mother = "mo", children = "ch") |>
  addMarker(name = "m1", geno = c(NA, "1/1", "1/2")) |>
  addMarker(name = "m2", geno = c(NA, "2/2", "2/2"))

isHomozygous(x)
isHomozygous(x, ids = "mo")
isHomozygous(x, count = TRUE)

}
