% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Remigration.R
\name{plot.Remigration}
\alias{plot.Remigration}
\title{Plot the remigration intervals.}
\usage{
\method{plot}{Remigration}(x, legend = TRUE, ...)
}
\arguments{
\item{x}{Object obtained from Bayesian.remigration()}

\item{legend}{TRUE or FALSE or c(x, y)}

\item{...}{Parameters transmitted to plot}
}
\value{
An invisible dataframe with values used for plotting.
}
\description{
Plot the remigration intervals.\cr
}
\details{
plot.Remigration plots the remigration intervals.
}
\examples{
\dontrun{
library(phenology)
# Example

# Each year a fraction of 0.9 is surviving
s <- c(s=0.9)
# Probability of tag retention; 0.8
t <- c(t=0.8)
# Time-conditional return probability - This is the true remigration rate
r <- c(r1=0.1, r2=0.8, r3=0.7, r4=0.7, r5=1)
# Capture probability
p <- c(p1=0.6, p2=0.6, p3=0.6, p4=0.6, p5=0.6)
# Number of observations for 400 tagged females after 1, 2, 3, 4, and 5 years
OBS <- c(400, 10, 120, 40, 20, 10)

kl_s <- length(s)
kl_t <- length(t)
kl_r <- length(r)
kl_p <- length(p)

pMCMC <- data.frame(Density=c("newdbeta", "newdbeta", rep("dunif", kl_r), 
                              rep("newdbeta", kl_p), "dunif"), 
                    Prior1=c(s, t, rep(0, kl_r), rep(0.2, kl_p), 0), 
                    Prior2=c(0.02, 0.02, rep(1, kl_r), rep(0.08, kl_p), 10), 
                    SDProp=c(0.05, 0.05, rep(0.05, kl_r), rep(0.05, kl_p), 0.05), 
                 Min=c(0, 0, rep(0, kl_r), rep(0, kl_p), 0),  
                 Max=c(1, 1, rep(1, kl_r), rep(1, kl_p), 10),  
                 Init=c(s, t, r, p, 1), stringsAsFactors = FALSE, 
                 row.names=c("s", 
                                "t", 
                                names(r), 
                                names(p), "sd")
)
rMCMC <- Bayesian.remigration(parameters = pMCMC, 
n.iter = 1000000, 
n.adapt = 300000,
trace=10000, 
data=OBS)

plot(rMCMC)

}
}
\seealso{
Other Model of Remigration Interval: 
\code{\link{Bayesian.remigration}()},
\code{\link{LnRI_norm}()},
\code{\link{RI}()},
\code{\link{RI2BP}()}
}
\author{
Marc Girondot
}
\concept{Model of Remigration Interval}
