% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-modifications.R
\name{phint_sift}
\alias{phint_sift}
\title{Remove instantaneous time spans from a phinterval}
\usage{
phint_sift(phint)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}
}
\value{
A \verb{<phinterval>} vector the same length as \code{phint}.
}
\description{
\code{phint_sift()} removes instantaneous spans (spans with 0 duration) from
phinterval elements. If all spans in an element are instantaneous, the result
is a hole.
}
\examples{
y2020 <- interval(as.Date("2020-01-01"), as.Date("2021-01-01"))
y2021 <- interval(as.Date("2021-01-01"), as.Date("2022-01-01"))
y2022 <- interval(as.Date("2022-01-01"), as.Date("2023-01-01"))

# The intersection of two adjacent intervals is instantaneous
new_years_2021 <- phint_intersect(y2020, y2021)
new_years_2021
phint_sift(new_years_2021)

# phint_sift() removes instants while keeping non-instantaneous spans
y2022_and_new_years <- phint_union(y2022, new_years_2021)
y2022_and_new_years
phint_sift(y2022_and_new_years)

}
