% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-operations.R
\name{phinterval-set-operations}
\alias{phinterval-set-operations}
\alias{phint_complement}
\alias{phint_union}
\alias{phint_intersect}
\alias{phint_setdiff}
\title{Vectorized set operations}
\usage{
phint_complement(phint)

phint_union(phint1, phint2)

phint_intersect(phint1, phint2, bounds = c("[]", "()"))

phint_setdiff(phint1, phint2)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}

\item{phint1, phint2}{\verb{[phinterval / Interval]}

A pair of \verb{<phinterval>} or \verb{<Interval>} vectors. \code{phint1} and \code{phint2}
are recycled to a common length using vctrs-style recycling.}

\item{bounds}{\verb{["[]" / "()"]}

For \code{phint_intersect()} only, whether span endpoints are inclusive or exclusive:
\itemize{
\item \code{"[]"} (default): Closed intervals - both endpoints are included
\item \code{"()"}: Open intervals - both endpoints are excluded
}

This affects adjacency and overlap detection. For example, with \code{bounds = "[]"},
the intervals \verb{[1, 5]} and \verb{[5, 10]} are considered adjacent (they share the
endpoint 5), while with \code{bounds = "()"}, \verb{(1, 5)} and \verb{(5, 10)} are disjoint
(neither includes 5).}
}
\value{
A \verb{<phinterval>} vector.
}
\description{
These functions perform elementwise set operations on \verb{<phinterval>} vectors,
treating each element as a set of non-overlapping intervals. They return a new
\verb{<phinterval>} vector representing the result of the corresponding set
operation. All functions follow vctrs-style recycling rules.
\itemize{
\item \code{phint_complement()} returns all time spans \emph{not covered} by \code{phint}.
\item \code{phint_union()} returns the intervals that are within either \code{phint1} or \code{phint2}.
\item \code{phint_intersect()} returns the intervals that are within both \code{phint1} and \code{phint2}.
\item \code{phint_setdiff()} returns intervals in \code{phint1} that are not within \code{phint2}.
}
}
\examples{
monday <- interval(as.Date("2025-11-10"), as.Date("2025-11-11"))
tuesday <- interval(as.Date("2025-11-11"), as.Date("2025-11-12"))
friday <- interval(as.Date("2025-11-14"), as.Date("2025-11-15"))
jan_1_to_5 <- interval(as.Date("2000-01-01"), as.Date("2000-01-05"))
jan_3_to_9 <- interval(as.Date("2000-01-03"), as.Date("2000-01-09"))

# Complement
phint_complement(jan_1_to_5)

# The complement of a hole is an infinite span covering all time
hole <- hole()
phint_complement(hole)

# Union
phint_union(c(monday, monday, monday), c(tuesday, friday, NA))

# Elements of length 1 are recycled
phint_union(monday, c(tuesday, friday, NA))

# Intersection
phint_intersect(jan_1_to_5, jan_3_to_9)

# The intersection of non-overlapping intervals is a hole
phint_intersect(monday, friday)

# By default, the intersection of adjacent intervals is instantaneous
phint_intersect(monday, tuesday)

# Use bounds to set the intersection of adjacent intervals to a hole
phint_intersect(monday, tuesday, bounds = "()")

# Set difference
phint_setdiff(jan_1_to_5, jan_3_to_9)
phint_setdiff(jan_3_to_9, jan_1_to_5)

# Instantaneous intervals do not affect the set difference
noon_monday <- as.POSIXct("2025-11-10 12:00:00")
phint_setdiff(monday, interval(noon_monday, noon_monday)) == monday

}
