% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.r
\name{merge2object_spct}
\alias{merge2object_spct}
\title{Merge into object_spct}
\usage{
merge2object_spct(
  x,
  y,
  by = "w.length",
  ...,
  w.length.out = x[["w.length"]],
  Tfr.type.out = "total"
)
}
\arguments{
\item{x, y}{a \code{filter_spct} object and a \code{reflector_spct} object.}

\item{by}{a vector of shared column names in \code{x} and \code{y} to merge
on; \code{by} defaults to \code{w.length}.}

\item{...}{other arguments passed to \code{dplyr::inner_join()}.}

\item{w.length.out}{numeric vector of wavelengths to be used for the returned
object (\eqn{nm}).}

\item{Tfr.type.out}{character string indicating whether transmittance values
in the returned object should be expressed as \code{"total"} or
\code{"internal"}. This applies only to the case when an \code{object_spct}
is returned.}
}
\value{
An \code{object_spct} is returned as the result of merging a
  \code{filter_spct} and a \code{reflector_spct} object.
}
\description{
Merge a \code{filter_spct} with a \code{reflector_spct} returning an
\code{object_spct} object, even if wavelength values are mismatched.
}
\note{
If a numeric vector is supplied as argument for \code{w.length.out},
  the two spectra are interpolated to the new wavelength values before
  merging. The default argument for \code{w.length.out} is
  \code{x[["w.length"]]}.
}
\seealso{
\code{\link[dplyr]{join}}
}
