% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_plot.R
\name{create_plot}
\alias{create_plot}
\title{Create Plot for Plausible Bounds}
\usage{
create_plot(
  result,
  show_supt = TRUE,
  show_pointwise = TRUE,
  show_annotations = TRUE
)
}
\arguments{
\item{result}{A plausible_bounds object returned by the plausible_bounds() function}

\item{show_supt}{Whether to show sup-t bounds (default: TRUE)}

\item{show_pointwise}{Whether to show pointwise bounds (default: TRUE)}

\item{show_annotations}{Whether to show annotations with test statistics and ATE (default: TRUE)}
}
\value{
A ggplot2 object
}
\description{
This function creates a plot of plausible bounds from a plausible_bounds object.
The plot displays plausible bounds as the main visualization, with optional
pointwise and sup-t bounds overlays.
Supports event study designs with pre-treatment periods.
}
\examples{

# Example with bighump estimates and correlation between estimates
data(estimates_bighump)
data(var_bighump)
result_complex <- plausible_bounds(estimates_bighump[1:4], var_bighump[1:4, 1:4])
plot_complex <- create_plot(result_complex)

}
