% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cal_rg_h2g_jk_alltraits.R
\name{Cal_rg_h2g_jk_alltraits}
\alias{Cal_rg_h2g_jk_alltraits}
\title{genomic-block jackknife and compute rg + h2g}
\usage{
Cal_rg_h2g_jk_alltraits(
  n_block = 200,
  hmp3,
  phenotype,
  munged_sumstats,
  ld_path,
  wld_path,
  sample_prev = NULL,
  population_prev = NULL
)
}
\arguments{
\item{n_block}{number of jackknife blocks.}

\item{hmp3}{Directory for hapmap 3 snplist.}

\item{phenotype}{Vector of the phenotype name}

\item{munged_sumstats}{All LDSC-munged GWAS .stat.gz}

\item{ld_path}{Path to directory containing ld score files.}

\item{wld_path}{Path to directory containing weight files.}

\item{sample_prev}{Vector of sample prevalence, in the same order of input GWAS summary statistics.}

\item{population_prev}{Vector of population prevalence, in the same order of input GWAS summary statistics.}
}
\value{
A named list containing block jackknife estimates of SNP-heritability and genetic
correlation across all input phenotypes. The list includes the following elements:
\itemize{
  \item \code{h2array}: A matrix of per-block SNP-heritability estimates on the
        observed scale. Rows correspond to jackknife blocks, and columns correspond
        to input phenotypes.
  \item \code{liah2array}: A matrix of per-block SNP-heritability estimates on the
        liability scale, with the same row and column structure as \code{h2array}.
  \item \code{rgarray}: A three-dimensional array of pairwise genetic correlation
        estimates. The first two dimensions represent phenotype pairs
        (rows and columns), and the third dimension indexes the jackknife blocks.
  \item \code{gcovarray}: A three-dimensional array of pairwise genetic covariance
        estimates, aligned in structure with \code{rgarray}.
}

Each element provides per-block estimates that can be used to compute
standard errors or confidence intervals via the block jackknife method.
}
\description{
This function performs genomic-block jackknife and computes rg + h2g.
}
