% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.pmrm_fit}
\alias{predict.pmrm_fit}
\title{Predict new outcomes}
\usage{
\method{predict}{pmrm_fit}(object, data = object$data, adjust = TRUE, confidence = 0.95, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{data}{A \code{tibble} or data frame with one row per patient visit.
This is the new data for making predictions.
It must have all the same columns as the original you fit with the model,
except that the outcome column can be entirely absent.
\code{object$data} is an example dataset that will work.
It is just like the original data, except that rows with missing
responses are removed, and the remaining rows are sorted
by patient ID and categorical scheduled visit.}

\item{adjust}{\code{TRUE} or \code{FALSE}.
\code{adjust = TRUE} returns estimates and inference for
covariate-adjusted \code{mu_ij}
values (defined in \code{vignette("models", package = "pmrm")}) for new data.
\code{adjust = FALSE} instead returns inference on \code{mu_ij - W \%*\% gamma},
the non-covariate-adjusted predictions useful in plotting a
continuous disease progression trajectory in \code{\link[=plot.pmrm_fit]{plot.pmrm_fit()}}.}

\item{confidence}{Numeric between 0 and 1, the confidence level
to use in the 2-sided confidence intervals.}

\item{...}{Not used.}
}
\value{
A \code{tibble} with one row for each row in the \code{data} argument and
columns \code{"estimate"}, \code{"standard_error"}, \code{"lower"}, and \code{"upper"}.
Columns \code{"lower"} and \code{"upper"} are lower and upper bounds of 2-sided
confidence intervals on the means.
(The confidence intervals are not actually truly prediction intervals
because they do not include variability from residuals.)
}
\description{
Return the expected values, standard errors,
and confidence intervals of new outcomes.
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  new_data <- pmrm_simulate_decline_proportional(
    patients = 1,
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  new_data$y <- NULL # Permitted but not strictly necessary.
  predict(fit, new_data)
}
\seealso{
Other predictions: 
\code{\link{fitted.pmrm_fit}()},
\code{\link{residuals.pmrm_fit}()}
}
\concept{predictions}
