% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_to_lifetab.R
\name{ex_to_lifetab_brass}
\alias{ex_to_lifetab_brass}
\title{Derive Life Tables that Match Life Expectancies,
using a Brass Logit Model}
\usage{
ex_to_lifetab_brass(
  target,
  standard,
  infant = c("constant", "linear", "CD", "AK"),
  child = c("constant", "linear", "CD"),
  closed = c("constant", "linear"),
  open = "constant",
  radix = 1e+05,
  suffix = NULL
)
}
\arguments{
\item{target}{A data frame containing a variable called
\code{"ex"}, and possibly other varibles. See Details.}

\item{standard}{A data frame containing variables
called \code{age} and \code{lx}, and possibly others.
See Details.}

\item{infant, child, closed, open}{Methods used to
calculate life expectancy. See \code{\link[=lifetab]{lifetab()}} for details.}

\item{radix}{Initial population for the
\code{lx} column in the derived life table(s).
Default is \code{100000}.}

\item{suffix}{Optional suffix added to life table columns.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
This function contained an error, and is deprecated.
Please use function \code{\link[=e0_to_lifetab_logit]{e0_to_lifetab_logit()}} instead.
}
\details{
Function \code{ex_to_lifetab_brass()} used formula

\deqn{\text{logit}(l_x^{\text{B}}) \approx \alpha + \beta \text{logit}(l_x^{\text{A}})},

instead of the conventional

\deqn{\text{logit}(1-l_x^{\text{B}}) \approx \alpha + \beta \text{logit}(1-l_x^{\text{A}})}.
}
