% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSetElements.R
\name{POSetElements}
\alias{POSetElements}
\title{Getting poset elements.}
\usage{
POSetElements(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A vector of labels (the names of the elements of the ground set \eqn{V}).
}
\description{
Gets the elements of the ground set \eqn{V} of the input poset \eqn{(V,\leq)}.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

gset <- POSetElements(pos)

}
