########################################################################################################################################
########################################################################################################################################
# LEGenerator
########################################################################################################################################
########################################################################################################################################


#' @title
#' Generator of all the linear extensions of a poset.
#'
#' @description
#' Creates an object of S4 class `LEGenerator` to generate all of the linear extensions of a given poset.
#' Actually, this function does not generate the linear extensions, but just the object that will generate them
#' by using function `LEGet`.
#'
#' @param poset An object of S4 class `POSet` representing the poset whose linear extensions are generated.
#' Argument `poset` must be created by using any function contained in the package aimed at building object of S4 class `POSet`
#' (e.g. [POSet()], [LinearPOSet()], [ProductPOSet()], ...) .
#'
#' @return
#' An S4 class object `LEGenerator`.
#'
#' @examples
#' el <- c("a", "b", "c", "d")
#'
#' dom <- matrix(c(
#'   "a", "b",
#'   "c", "b",
#'   "b", "d"
#' ), ncol = 2, byrow = TRUE)
#'
#' pos <- POSet(elements = el, dom = dom)
#'
#' LEgen <- LEGenerator(pos)
#'
#'
#' @name LEGenerator
#' @export LEGenerator
LEGenerator <- function(poset) {
  if (!methods::is(poset, "POSet")) {
    stop("poset must be of class POSet")
  }
  tryCatch({
    ptr <- .Call("_BuildLEGenerator", poset@ptr)
    result <- methods::new("LEGenerator", ptr=ptr)
    return (result)
  }, error = function(err) {
    err_split <- strsplit(err[[1]], split = ":")
    stop(err_split[[1]][length(err_split[[1]])])
  }) # END tryCatch
}
