% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.linear_cre.R, R/summary.linear_fe.R,
%   R/summary.linear_re.R
\name{summary.linear_cre}
\alias{summary.linear_cre}
\alias{summary.linear_fe}
\alias{summary.linear_re}
\title{Result Summaries of Covariate Estimates from a fitted \code{linear_fe}, \code{linear_re} or \code{linear_cre} object}
\usage{
\method{summary}{linear_cre}(object, parm, level = 0.95, null = 0, ...)

\method{summary}{linear_fe}(object, parm, level = 0.95, null = 0, ...)

\method{summary}{linear_re}(object, parm, level = 0.95, null = 0, ...)
}
\arguments{
\item{object}{a model fitted from \code{linear_fe} or \code{linear_re} or \code{linear_cre}.}

\item{parm}{specifies a subset of covariates for which the result summaries should be output.
By default, all covariates are included.}

\item{level}{the confidence level during the hypothesis test, meaning a significance level of \eqn{1 - \text{level}}.
The default value is 0.95.}

\item{null}{a number defining the null hypothesis for the covariate estimates. The default value is \code{0}.}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A data frame containing summary statistics for covariate estimates, with the following columns:
\item{Estimate}{the estimates of covariate coefficients.}
\item{Std.Error}{the standard error of the estimate.}
\item{Stat}{the test statistic.}
\item{p value}{the p-value for the hypothesis test.}
\item{CI.upper}{the lower bound of the confidence interval.}
\item{CI.lower}{the upper bound of the confidence interval.}
}
\description{
Provide the summary statistics for the covariate estimates for a fixed/random/correlated random effect linear model.
}
\examples{
data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
data <- data.frame(outcome, ProvID, covar)
outcome.char <- colnames(data)[1]
ProvID.char <- colnames(data)[2]
wb.char <- c("z1", "z2")
other.char <- c("z3", "z4", "z5")
fit_cre <- linear_cre(data = data, Y.char = outcome.char, ProvID.char = ProvID.char,
wb.char = wb.char, other.char = other.char)
summary(fit_cre)

data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
fit_fe <- linear_fe(Y = outcome, Z = covar, ProvID = ProvID)
summary(fit_fe)

data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
fit_re <- linear_fe(Y = outcome, Z = covar, ProvID = ProvID)
summary(fit_re)

}
