% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_calibration.R
\name{is_ps_calibrated}
\alias{is_ps_calibrated}
\title{Check if propensity scores are calibrated}
\usage{
is_ps_calibrated(x)
}
\arguments{
\item{x}{An object to test.}
}
\value{
A single \code{TRUE} or \code{FALSE}.
}
\description{
\code{is_ps_calibrated()} tests whether \code{x} is a calibrated propensity score
object (class \code{ps_calib}) or a \code{psw} object derived from calibrated scores.
}
\examples{
ps <- runif(100)
exposure <- rbinom(100, 1, ps)

is_ps_calibrated(ps)

calibrated <- ps_calibrate(ps, exposure, smooth = FALSE)
is_ps_calibrated(calibrated)

}
\seealso{
\code{\link[=ps_calibrate]{ps_calibrate()}} to calibrate propensity scores.
}
