% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\title{Intensity normalisation}
\usage{
normalise(data, sample, intensity_log2, method = "median")
}
\arguments{
\item{data}{a data frame containing at least sample names and intensity values. Please note that if the
data frame is grouped, the normalisation will be computed by group.}

\item{sample}{a character column in the \code{data} data frame that contains the sample names.}

\item{intensity_log2}{a numeric column in the \code{data} data frame that contains the log2 transformed
intensity values to be normalised.}

\item{method}{a character value specifying the method to be used for normalisation. Default
is "median".}
}
\value{
A data frame with a column called \code{normalised_intensity_log2} containing the
normalised intensity values.
}
\description{
Performs normalisation on intensities. For median normalisation the normalised intensity is the
original intensity minus the run median plus the global median. This is also the way it is
implemented in the Spectronaut search engine.
}
\examples{
data <- data.frame(
  r_file_name = c("s1", "s2", "s3", "s1", "s2", "s3"),
  intensity_log2 = c(18, 19, 17, 20, 21, 19)
)

normalise(data,
  sample = r_file_name,
  intensity_log2 = intensity_log2,
  method = "median"
)
}
