% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.r
\docType{data}
\name{inc_ineq}
\alias{inc_ineq}
\title{Income and Inequality Data}
\format{
A data frame with 12810 rows and 6 variables
\describe{
\item{country}{Country Name}
\item{year}{Year}
\item{rgdpe}{Expenditure-side real GDP at chained PPPs (in mil. 2017 US Dollars).
  Useful for making cross-country/cross-time comparisons of relative living standards. [PWT]}
\item{pop}{Population in millions. [PWT]}
\item{gdp_cap}{GDP divided by population from PWT.}
\item{gini}{Gini Coefficient (Disposable Income) [SWIID]}
}
}
\description{
This merges the Gini coefficient measured in disposable income from the
Standardized World Income Inequality Data (Solt, 2020) with GDP and population
data from the Penn World Tables version 10 (Feenstra et. al., 2015).
}
\references{
Feenstra, Robert C., Robert Inklaar and Marcel P. Timmer (2015), "The Next Generation of the Penn World Table" American Economic Review, 105(10), 3150-3182, available for download at \url{https://www.rug.nl/ggdc/productivity/pwt/}.

Solt, Frederick. 2020. "Measuring Income Inequality Across Countries and Over Time: The Standardized World Income Inequality Database." Social Science Quarterly 101(3):1183-1199. SWIID Version 9.0, October 2020.
}
\keyword{datasets}
