% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmid_to_pmc.R
\name{pmid_to_pmc}
\alias{pmid_to_pmc}
\title{Convert PubMed IDs (PMIDs) to PMC IDs}
\usage{
pmid_to_pmc(pmids, batch_size = 200L, sleep = 0.5)
}
\arguments{
\item{pmids}{A character or numeric vector of PubMed IDs (PMIDs) to convert.}

\item{batch_size}{An integer specifying the number of PMIDs to process per
batch. Defaults to 200L. The NCBI API has limitations on batch sizes.}

\item{sleep}{A numeric value specifying the number of seconds to pause
between API requests. Defaults to 0.5 seconds to respect API rate limits.}
}
\value{
A data.table with columns:
  \itemize{
    \item \code{pmid}: The input PubMed ID
    \item \code{pmcid}: The corresponding PMC ID (NA if not available in PMC)
    \item \code{doi}: The corresponding DOI (NA if not available)
  }
  Results are ordered by PMID. Returns NULL with a message if the API is
  unavailable or returns invalid data.
}
\description{
This function converts a vector of PubMed IDs (PMIDs) to their corresponding
PubMed Central (PMC) IDs and DOIs using the NCBI ID Converter API.
}
\examples{
\donttest{
if (interactive()) {
  # Convert a single PMID to PMC ID
  result <- pmid_to_pmc("12345678")
  
  # Convert multiple PMIDs
  pmids <- c("12345678", "23456789", "34567890")
  result <- pmid_to_pmc(pmids, batch_size = 10, sleep = 1)
}
}

}
