% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans_implementation.R
\name{qbrms_emmeans}
\alias{qbrms_emmeans}
\title{Estimated Marginal Means for qbrms models}
\usage{
qbrms_emmeans(object, specs, at = NULL, nsim = 1000, prob = 0.95, ...)
}
\arguments{
\item{object}{A \code{qbrms_fit}.}

\item{specs}{Character vector naming factor(s) for EMMs, or a string
containing a formula with a right-hand side (for example, \code{"~ group"}
or \code{"y ~ group"}). If multiple terms are provided, a full grid is used.}

\item{at}{Optional named list giving values at which to hold other predictors.
Numerics are fixed at their means if not supplied; factors at their modal level.}

\item{nsim}{Number of posterior draws for uncertainty.}

\item{prob}{Interval mass (default 0.95).}

\item{...}{Additional arguments (currently not used).}
}
\value{
A data frame of class \code{qbrms_emmeans}.
}
\description{
Compute estimated marginal means (least-squares means) for factor terms
and their combinations for a \code{qbrms_fit}, using a multivariate-normal
approximation to the posterior of the fixed effects.
}
